/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.minecraft.entity.EntityLivingBase;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableAbsorptionData;
import org.spongepowered.api.data.manipulator.mutable.entity.AbsorptionData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeAbsorptionData;
import org.spongepowered.common.data.processor.common.AbstractSingleDataSingleTargetProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public final class AbsorptionDataProcessor
extends AbstractSingleDataSingleTargetProcessor<EntityLivingBase, Double, Value<Double>, AbsorptionData, ImmutableAbsorptionData> {
    public AbsorptionDataProcessor() {
        super(Keys.ABSORPTION, EntityLivingBase.class);
    }

    @Override
    protected AbsorptionData createManipulator() {
        return new SpongeAbsorptionData();
    }

    @Override
    protected boolean set(EntityLivingBase living, Double value) {
        Preconditions.checkNotNull((Object)value, (Object)"value");
        living.func_110149_m(value.floatValue());
        return true;
    }

    @Override
    protected Optional<Double> getVal(EntityLivingBase living) {
        return Optional.of(Double.valueOf(living.func_110139_bj()));
    }

    @Override
    protected ImmutableValue<Double> constructImmutableValue(Double value) {
        return new ImmutableSpongeValue<Double>(this.key, 0.0, value);
    }

    @Override
    protected Value<Double> constructValue(Double actualValue) {
        return new SpongeValue<Double>(this.key, 0.0, actualValue);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

