/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.multi;

import com.google.common.collect.Maps;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.ImmutableMobSpawnerData;
import org.spongepowered.api.data.manipulator.mutable.MobSpawnerData;
import org.spongepowered.common.data.manipulator.mutable.SpongeMobSpawnerData;
import org.spongepowered.common.data.processor.common.AbstractMultiDataSingleTargetProcessor;
import org.spongepowered.common.data.processor.common.SpawnerUtils;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.interfaces.IMixinMobSpawner;

public class MobSpawnerDataProcessor
extends AbstractMultiDataSingleTargetProcessor<IMixinMobSpawner, MobSpawnerData, ImmutableMobSpawnerData> {
    public MobSpawnerDataProcessor() {
        super(IMixinMobSpawner.class);
    }

    @Override
    protected boolean doesDataExist(IMixinMobSpawner entity) {
        return true;
    }

    @Override
    protected boolean set(IMixinMobSpawner entity, Map<Key<?>, Object> values) {
        MobSpawnerBaseLogic logic = entity.getLogic();
        SpawnerUtils.applyData(logic, values);
        return true;
    }

    @Override
    protected Map<Key<?>, ?> getValues(IMixinMobSpawner spawner) {
        MobSpawnerBaseLogic logic = spawner.getLogic();
        IdentityHashMap values = Maps.newIdentityHashMap();
        values.put(Keys.SPAWNER_REMAINING_DELAY, (short)logic.field_98286_b);
        values.put(Keys.SPAWNER_MINIMUM_DELAY, (short)logic.field_98283_g);
        values.put(Keys.SPAWNER_MAXIMUM_DELAY, (short)logic.field_98293_h);
        values.put(Keys.SPAWNER_SPAWN_COUNT, (short)logic.field_98294_i);
        values.put(Keys.SPAWNER_MAXIMUM_NEARBY_ENTITIES, (short)logic.field_98292_k);
        values.put(Keys.SPAWNER_REQUIRED_PLAYER_RANGE, (short)logic.field_98289_l);
        values.put(Keys.SPAWNER_SPAWN_RANGE, (short)logic.field_98290_m);
        values.put(Keys.SPAWNER_NEXT_ENTITY_TO_SPAWN, SpawnerUtils.getNextEntity(logic));
        values.put(Keys.SPAWNER_ENTITIES, SpawnerUtils.getEntities(logic));
        return values;
    }

    @Override
    protected MobSpawnerData createManipulator() {
        return new SpongeMobSpawnerData();
    }

    @Override
    public Optional<MobSpawnerData> fill(DataContainer container, MobSpawnerData data) {
        if (!container.contains(Keys.SPAWNER_REMAINING_DELAY.getQuery(), Keys.SPAWNER_MINIMUM_DELAY.getQuery(), Keys.SPAWNER_MAXIMUM_DELAY.getQuery(), Keys.SPAWNER_SPAWN_COUNT.getQuery(), Keys.SPAWNER_MAXIMUM_NEARBY_ENTITIES.getQuery(), Keys.SPAWNER_REQUIRED_PLAYER_RANGE.getQuery(), Keys.SPAWNER_SPAWN_RANGE.getQuery(), Keys.SPAWNER_NEXT_ENTITY_TO_SPAWN.getQuery(), Keys.SPAWNER_ENTITIES.getQuery())) {
            return Optional.empty();
        }
        data.set(Keys.SPAWNER_REMAINING_DELAY, DataUtil.getData(container, Keys.SPAWNER_REMAINING_DELAY));
        data.set(Keys.SPAWNER_MINIMUM_DELAY, DataUtil.getData(container, Keys.SPAWNER_MINIMUM_DELAY));
        data.set(Keys.SPAWNER_MAXIMUM_DELAY, DataUtil.getData(container, Keys.SPAWNER_MAXIMUM_DELAY));
        data.set(Keys.SPAWNER_SPAWN_COUNT, DataUtil.getData(container, Keys.SPAWNER_SPAWN_COUNT));
        data.set(Keys.SPAWNER_MAXIMUM_NEARBY_ENTITIES, DataUtil.getData(container, Keys.SPAWNER_MAXIMUM_NEARBY_ENTITIES));
        data.set(Keys.SPAWNER_REQUIRED_PLAYER_RANGE, DataUtil.getData(container, Keys.SPAWNER_REQUIRED_PLAYER_RANGE));
        data.set(Keys.SPAWNER_SPAWN_RANGE, DataUtil.getData(container, Keys.SPAWNER_SPAWN_RANGE));
        data.set(Keys.SPAWNER_NEXT_ENTITY_TO_SPAWN, DataUtil.getData(container, Keys.SPAWNER_NEXT_ENTITY_TO_SPAWN));
        data.set(Keys.SPAWNER_ENTITIES, DataUtil.getData(container, Keys.SPAWNER_ENTITIES));
        return Optional.of(data);
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        return DataTransactionResult.failNoData();
    }
}

