/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.value.entity;

import java.util.Optional;
import net.minecraft.entity.Entity;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.common.data.processor.common.AbstractSpongeValueProcessor;
import org.spongepowered.common.data.value.SpongeValueFactory;

public class FireTicksValueProcessor
extends AbstractSpongeValueProcessor<Entity, Integer, MutableBoundedValue<Integer>> {
    public FireTicksValueProcessor() {
        super(Entity.class, Keys.FIRE_TICKS);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        if (container instanceof Entity && ((Entity)container).field_190534_ay >= 1) {
            DataTransactionResult.Builder builder = DataTransactionResult.builder();
            builder.replace(((MutableBoundedValue)this.getApiValueFromContainer(container).get()).asImmutable());
            builder.replace(container.getValue(Keys.FIRE_DAMAGE_DELAY).get().asImmutable());
            ((Entity)container).func_70066_B();
            return builder.result(DataTransactionResult.Type.SUCCESS).build();
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    protected MutableBoundedValue<Integer> constructValue(Integer defaultValue) {
        return SpongeValueFactory.boundedBuilder(Keys.FIRE_TICKS).defaultValue(10).minimum(1).maximum(Integer.MAX_VALUE).actualValue(defaultValue).build();
    }

    @Override
    protected boolean set(Entity container, Integer value) {
        container.field_190534_ay = value;
        return true;
    }

    @Override
    protected Optional<Integer> getVal(Entity container) {
        if (container.field_190534_ay > 0) {
            return Optional.of(container.field_190534_ay);
        }
        return Optional.empty();
    }

    @Override
    protected ImmutableValue<Integer> constructImmutableValue(Integer value) {
        return this.constructValue(value).asImmutable();
    }
}

