/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.value.entity;

import java.util.Optional;
import net.minecraft.entity.passive.EntityHorse;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.HorseStyle;
import org.spongepowered.api.data.type.HorseStyles;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.processor.common.AbstractSpongeValueProcessor;
import org.spongepowered.common.data.processor.common.HorseUtils;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.entity.SpongeHorseColor;
import org.spongepowered.common.entity.SpongeHorseStyle;

public class HorseStyleValueProcessor
extends AbstractSpongeValueProcessor<EntityHorse, HorseStyle, Value<HorseStyle>> {
    public HorseStyleValueProcessor() {
        super(EntityHorse.class, Keys.HORSE_STYLE);
    }

    @Override
    protected Value<HorseStyle> constructValue(HorseStyle defaultValue) {
        return new SpongeValue<HorseStyle>(Keys.HORSE_STYLE, defaultValue);
    }

    @Override
    protected boolean set(EntityHorse container, HorseStyle value) {
        SpongeHorseColor color = (SpongeHorseColor)HorseUtils.getHorseColor(container);
        container.func_110235_q(HorseUtils.getInternalVariant(color, (SpongeHorseStyle)value));
        return true;
    }

    @Override
    protected Optional<HorseStyle> getVal(EntityHorse container) {
        return Optional.of(HorseUtils.getHorseStyle(container));
    }

    @Override
    protected ImmutableValue<HorseStyle> constructImmutableValue(HorseStyle value) {
        return ImmutableSpongeValue.cachedOf(Keys.HORSE_STYLE, HorseStyles.NONE, value);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

