/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.value.entity;

import java.util.Optional;
import net.minecraft.entity.item.EntityItem;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.processor.common.AbstractSpongeValueProcessor;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.interfaces.entity.item.IMixinEntityItem;

public class InfiniteDespawnDelayValueProcessor
extends AbstractSpongeValueProcessor<EntityItem, Boolean, Value<Boolean>> {
    public InfiniteDespawnDelayValueProcessor() {
        super(EntityItem.class, Keys.INFINITE_DESPAWN_DELAY);
    }

    @Override
    public Value<Boolean> constructValue(Boolean defaultValue) {
        return new SpongeValue<Boolean>(Keys.INFINITE_DESPAWN_DELAY, false, defaultValue);
    }

    @Override
    protected boolean set(EntityItem container, Boolean value) {
        ((IMixinEntityItem)container).setPickupDelay(value != false ? Short.MIN_VALUE : 0, value);
        return true;
    }

    @Override
    protected Optional<Boolean> getVal(EntityItem container) {
        return Optional.of(((IMixinEntityItem)container).infinitePickupDelay());
    }

    @Override
    protected ImmutableValue<Boolean> constructImmutableValue(Boolean value) {
        return this.constructValue(value).asImmutable();
    }

    @Override
    protected boolean supports(EntityItem container) {
        return true;
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

