/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.value.immutable;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import java.util.function.Predicate;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.meta.PatternLayer;
import org.spongepowered.api.data.type.BannerPatternShape;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutablePatternListValue;
import org.spongepowered.api.data.value.mutable.PatternListValue;
import org.spongepowered.common.data.meta.SpongePatternLayer;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeListValue;
import org.spongepowered.common.data.value.mutable.SpongePatternListValue;

public class ImmutableSpongePatternListValue
extends ImmutableSpongeListValue<PatternLayer>
implements ImmutablePatternListValue {
    public ImmutableSpongePatternListValue(Key<? extends BaseValue<List<PatternLayer>>> key, List<PatternLayer> actualValue) {
        super(key, ImmutableList.copyOf(actualValue));
    }

    @Override
    public ImmutablePatternListValue with(List<PatternLayer> value) {
        return new ImmutableSpongePatternListValue(this.getKey(), (List<PatternLayer>)ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(value))));
    }

    @Override
    public ImmutablePatternListValue transform(Function<List<PatternLayer>, List<PatternLayer>> function) {
        return new ImmutableSpongePatternListValue(this.getKey(), (List<PatternLayer>)ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(((Function)Preconditions.checkNotNull(function)).apply(this.actualValue)))));
    }

    @Override
    public PatternListValue asMutable() {
        ArrayList list = Lists.newArrayList();
        list.addAll((Collection)this.actualValue);
        return new SpongePatternListValue(this.getKey(), list);
    }

    @Override
    public ImmutablePatternListValue withElement(PatternLayer elements) {
        return new ImmutableSpongePatternListValue(this.getKey(), (List<PatternLayer>)ImmutableList.builder().addAll((Iterable)this.actualValue).add((Object)elements).build());
    }

    @Override
    public ImmutablePatternListValue withAll(Iterable<PatternLayer> elements) {
        return new ImmutableSpongePatternListValue(this.getKey(), (List<PatternLayer>)ImmutableList.builder().addAll((Iterable)this.actualValue).addAll(elements).build());
    }

    @Override
    public ImmutablePatternListValue without(PatternLayer element) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ((List)this.actualValue).stream().filter(existingElement -> !existingElement.equals(element)).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return new ImmutableSpongePatternListValue(this.getKey(), (List<PatternLayer>)builder.build());
    }

    @Override
    public ImmutablePatternListValue withoutAll(Iterable<PatternLayer> elements) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ((List)this.actualValue).stream().filter(existingElement -> !Iterables.contains((Iterable)elements, (Object)existingElement)).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return new ImmutableSpongePatternListValue(this.getKey(), (List<PatternLayer>)builder.build());
    }

    @Override
    public ImmutablePatternListValue withoutAll(Predicate<PatternLayer> predicate) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ((List)this.actualValue).stream().filter(existing -> ((Predicate)Preconditions.checkNotNull((Object)predicate)).test(existing)).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return new ImmutableSpongePatternListValue(this.getKey(), (List<PatternLayer>)builder.build());
    }

    @Override
    public ImmutablePatternListValue with(int index, PatternLayer value) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ListIterator iterator = ((List)this.actualValue).listIterator();
        while (iterator.hasNext()) {
            if (iterator.nextIndex() - 1 == index) {
                builder.add(Preconditions.checkNotNull((Object)value));
                iterator.next();
                continue;
            }
            builder.add(iterator.next());
        }
        return new ImmutableSpongePatternListValue(this.getKey(), (List<PatternLayer>)builder.build());
    }

    @Override
    public ImmutablePatternListValue with(int index, Iterable<PatternLayer> values) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ListIterator iterator = ((List)this.actualValue).listIterator();
        while (iterator.hasNext()) {
            if (iterator.nextIndex() - 1 == index) {
                builder.addAll(values);
            }
            builder.add(iterator.next());
        }
        return new ImmutableSpongePatternListValue(this.getKey(), (List<PatternLayer>)builder.build());
    }

    @Override
    public ImmutablePatternListValue without(int index) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ListIterator iterator = ((List)this.actualValue).listIterator();
        while (iterator.hasNext()) {
            if (iterator.nextIndex() - 1 == index) continue;
            builder.add(iterator.next());
        }
        return new ImmutableSpongePatternListValue(this.getKey(), (List<PatternLayer>)builder.build());
    }

    @Override
    public ImmutablePatternListValue set(int index, PatternLayer element) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ListIterator iterator = ((List)this.actualValue).listIterator();
        while (iterator.hasNext()) {
            if (iterator.nextIndex() - 1 == index) {
                builder.add(Preconditions.checkNotNull((Object)element));
                iterator.next();
                continue;
            }
            builder.add(iterator.next());
        }
        return new ImmutableSpongePatternListValue(this.getKey(), (List<PatternLayer>)builder.build());
    }

    @Override
    public ImmutablePatternListValue with(BannerPatternShape patternShape, DyeColor color) {
        return this.withElement(new SpongePatternLayer(patternShape, color));
    }

    @Override
    public ImmutablePatternListValue with(int index, BannerPatternShape patternShape, DyeColor color) {
        return this.with(index, new SpongePatternLayer(patternShape, color));
    }

    @Override
    public ImmutablePatternListValue set(int index, BannerPatternShape patternShape, DyeColor color) {
        return this.set(index, new SpongePatternLayer(patternShape, color));
    }
}

