/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.value.mutable;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableMapValue;
import org.spongepowered.api.data.value.mutable.MapValue;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeMapValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class SpongeMapValue<K, V>
extends SpongeValue<Map<K, V>>
implements MapValue<K, V> {
    public SpongeMapValue(Key<? extends BaseValue<Map<K, V>>> key) {
        this((Key<BaseValue<Map<K, V>>>)key, Maps.newHashMap());
    }

    public SpongeMapValue(Key<? extends BaseValue<Map<K, V>>> key, Map<K, V> actualValue) {
        this((Key<BaseValue<Map<K, V>>>)key, (Map<K, V>)ImmutableMap.of(), actualValue);
    }

    public SpongeMapValue(Key<? extends BaseValue<Map<K, V>>> key, Map<K, V> defaultMap, Map<K, V> actualMap) {
        super(key, ImmutableMap.copyOf(defaultMap), Maps.newHashMap(actualMap));
    }

    @Override
    public MapValue<K, V> transform(Function<Map<K, V>, Map<K, V>> function) {
        this.actualValue = Maps.newHashMap((Map)((Map)Preconditions.checkNotNull(((Function)Preconditions.checkNotNull(function)).apply(this.actualValue))));
        return this;
    }

    @Override
    public ImmutableMapValue<K, V> asImmutable() {
        return new ImmutableSpongeMapValue(this.getKey(), ImmutableMap.copyOf((Map)((Map)this.actualValue)));
    }

    @Override
    public int size() {
        return ((Map)this.actualValue).size();
    }

    @Override
    public MapValue<K, V> put(K key, V value) {
        ((Map)this.actualValue).put(Preconditions.checkNotNull(key), Preconditions.checkNotNull(value));
        return this;
    }

    @Override
    public MapValue<K, V> putAll(Map<K, V> map) {
        ((Map)this.actualValue).putAll((Map)Preconditions.checkNotNull(map));
        return this;
    }

    @Override
    public MapValue<K, V> remove(K key) {
        ((Map)this.actualValue).remove(Preconditions.checkNotNull(key));
        return this;
    }

    @Override
    public MapValue<K, V> removeAll(Iterable<K> keys) {
        for (K key : keys) {
            ((Map)this.actualValue).remove(Preconditions.checkNotNull(key));
        }
        return this;
    }

    @Override
    public MapValue<K, V> removeAll(Predicate<Map.Entry<K, V>> predicate) {
        Iterator iterator = ((Map)this.actualValue).entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (((Predicate)Preconditions.checkNotNull(predicate)).test(entry)) continue;
            iterator.remove();
        }
        return this;
    }

    @Override
    public boolean containsKey(K key) {
        return ((Map)this.actualValue).containsKey(Preconditions.checkNotNull(key));
    }

    @Override
    public boolean containsValue(V value) {
        return ((Map)this.actualValue).containsValue(Preconditions.checkNotNull(value));
    }

    @Override
    public ImmutableSet<K> keySet() {
        return ImmutableSet.copyOf(((Map)this.actualValue).keySet());
    }

    @Override
    public ImmutableSet<Map.Entry<K, V>> entrySet() {
        return ImmutableSet.copyOf(((Map)this.actualValue).entrySet());
    }

    @Override
    public ImmutableCollection<V> values() {
        return ImmutableSet.copyOf(((Map)this.actualValue).values());
    }
}

