/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.effect.particle;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3f;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketDestroyEntities;
import net.minecraft.network.play.server.SPacketEffect;
import net.minecraft.network.play.server.SPacketEntityMetadata;
import net.minecraft.network.play.server.SPacketEntityStatus;
import net.minecraft.network.play.server.SPacketParticles;
import net.minecraft.network.play.server.SPacketSpawnObject;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.type.NotePitch;
import org.spongepowered.api.effect.particle.ParticleOptions;
import org.spongepowered.api.effect.particle.ParticleTypes;
import org.spongepowered.api.item.FireworkEffect;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.Color;
import org.spongepowered.api.util.Direction;
import org.spongepowered.common.data.processor.common.FireworkUtils;
import org.spongepowered.common.data.type.SpongeNotePitch;
import org.spongepowered.common.effect.particle.ICachedParticleEffect;
import org.spongepowered.common.effect.particle.SpongeParticleEffect;
import org.spongepowered.common.effect.particle.SpongeParticleType;
import org.spongepowered.common.item.inventory.SpongeItemStackSnapshot;

public final class SpongeParticleHelper {
    public static List<Packet<?>> toPackets(SpongeParticleEffect effect, Vector3d position) {
        ICachedParticleEffect cachedPacket = effect.cachedParticle;
        if (cachedPacket == null) {
            cachedPacket = effect.cachedParticle = SpongeParticleHelper.toCachedPacket(effect);
        }
        if (cachedPacket == EmptyCachedPacket.INSTANCE) {
            return Collections.emptyList();
        }
        ArrayList packets = new ArrayList();
        cachedPacket.process(position, packets);
        return packets;
    }

    private static int getBlockState(SpongeParticleEffect effect, Optional<BlockState> defaultBlockState) {
        Optional<BlockState> blockState = effect.getOption(ParticleOptions.BLOCK_STATE);
        if (blockState.isPresent()) {
            return Block.func_176210_f((IBlockState)((IBlockState)blockState.get()));
        }
        Optional<ItemStackSnapshot> optSnapshot = effect.getOption(ParticleOptions.ITEM_STACK_SNAPSHOT);
        if (optSnapshot.isPresent()) {
            ItemStackSnapshot snapshot = optSnapshot.get();
            Optional<BlockType> blockType = snapshot.getType().getBlock();
            if (blockType.isPresent()) {
                return Block.func_176210_f((IBlockState)((Block)blockType.get()).func_176203_a(((SpongeItemStackSnapshot)snapshot).getDamageValue()));
            }
            return 0;
        }
        return Block.func_176210_f((IBlockState)((IBlockState)defaultBlockState.get()));
    }

    private static int getDirectionData(Direction direction) {
        if (direction.isSecondaryOrdinal()) {
            direction = Direction.getClosest(direction.asOffset(), Direction.Division.ORDINAL);
        }
        switch (direction) {
            case SOUTHEAST: {
                return 0;
            }
            case SOUTH: {
                return 1;
            }
            case SOUTHWEST: {
                return 2;
            }
            case EAST: {
                return 3;
            }
            case WEST: {
                return 5;
            }
            case NORTHEAST: {
                return 6;
            }
            case NORTH: {
                return 7;
            }
            case NORTHWEST: {
                return 8;
            }
        }
        return 4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ICachedParticleEffect toCachedPacket(SpongeParticleEffect effect) {
        Optional<Double> defaultScale;
        Optional<ItemStackSnapshot> defaultSnapshot;
        Optional<BlockState> defaultBlockState;
        SpongeParticleType type = effect.getType();
        EnumParticleTypes internal = type.getInternalType();
        if (internal == null) {
            if (type == ParticleTypes.FIREWORKS) {
                List<FireworkEffect> effects = type.getDefaultOption(ParticleOptions.FIREWORK_EFFECTS).get();
                if (effects.isEmpty()) {
                    return EmptyCachedPacket.INSTANCE;
                }
                ItemStack itemStack = new ItemStack(Items.field_151152_bP);
                FireworkUtils.setFireworkEffects(itemStack, effects);
                SPacketEntityMetadata packetEntityMetadata = new SPacketEntityMetadata();
                packetEntityMetadata.field_149379_a = CachedFireworkPacket.FIREWORK_ROCKET_ID;
                packetEntityMetadata.field_149378_b = new ArrayList();
                packetEntityMetadata.field_149378_b.add(new EntityDataManager.DataEntry(EntityFireworkRocket.field_184566_a, (Object)itemStack));
                return new CachedFireworkPacket(packetEntityMetadata);
            }
            if (type == ParticleTypes.FERTILIZER) {
                int quantity = effect.getOptionOrDefault(ParticleOptions.QUANTITY).get();
                return new CachedEffectPacket(2005, quantity, false);
            }
            if (type == ParticleTypes.SPLASH_POTION) {
                Potion potion = (Potion)effect.getOptionOrDefault(ParticleOptions.POTION_EFFECT_TYPE).get();
                for (PotionType potionType : PotionType.field_185176_a) {
                    for (PotionEffect potionEffect : potionType.func_185170_a()) {
                        if (potionEffect.func_188419_a() != potion) continue;
                        return new CachedEffectPacket(2002, PotionType.field_185176_a.func_148757_b((Object)potionType), false);
                    }
                }
                return EmptyCachedPacket.INSTANCE;
            }
            if (type == ParticleTypes.BREAK_BLOCK) {
                int state = SpongeParticleHelper.getBlockState(effect, type.getDefaultOption(ParticleOptions.BLOCK_STATE));
                if (state != 0) return new CachedEffectPacket(2001, state, false);
                return EmptyCachedPacket.INSTANCE;
            }
            if (type == ParticleTypes.MOBSPAWNER_FLAMES) {
                return new CachedEffectPacket(2004, 0, false);
            }
            if (type == ParticleTypes.ENDER_TELEPORT) {
                return new CachedEffectPacket(2003, 0, false);
            }
            if (type == ParticleTypes.DRAGON_BREATH_ATTACK) {
                return new CachedEffectPacket(2006, 0, false);
            }
            if (type != ParticleTypes.FIRE_SMOKE) return EmptyCachedPacket.INSTANCE;
            Direction direction = effect.getOptionOrDefault(ParticleOptions.DIRECTION).get();
            return new CachedEffectPacket(2000, SpongeParticleHelper.getDirectionData(direction), false);
        }
        Vector3f offset = effect.getOption(ParticleOptions.OFFSET).map(Vector3d::toFloat).orElse(Vector3f.ZERO);
        int quantity = effect.getOption(ParticleOptions.QUANTITY).orElse(1);
        int[] extra = null;
        double f0 = 0.0;
        double f1 = 0.0;
        double f2 = 0.0;
        if (internal != EnumParticleTypes.ITEM_CRACK && (defaultBlockState = type.getDefaultOption(ParticleOptions.BLOCK_STATE)).isPresent()) {
            int state = SpongeParticleHelper.getBlockState(effect, defaultBlockState);
            if (state == 0) {
                return EmptyCachedPacket.INSTANCE;
            }
            extra = new int[]{state};
        }
        if (extra == null && (defaultSnapshot = type.getDefaultOption(ParticleOptions.ITEM_STACK_SNAPSHOT)).isPresent()) {
            Optional<ItemStackSnapshot> optSnapshot = effect.getOption(ParticleOptions.ITEM_STACK_SNAPSHOT);
            if (optSnapshot.isPresent()) {
                ItemStackSnapshot snapshot = optSnapshot.get();
                extra = new int[]{Item.func_150891_b((Item)((Item)snapshot.getType())), ((SpongeItemStackSnapshot)snapshot).getDamageValue()};
            } else {
                Optional<BlockState> optBlockState = effect.getOption(ParticleOptions.BLOCK_STATE);
                if (optBlockState.isPresent()) {
                    BlockState blockState = optBlockState.get();
                    Optional<ItemType> optItemType = blockState.getType().getItem();
                    if (!optItemType.isPresent()) return EmptyCachedPacket.INSTANCE;
                    extra = new int[]{Item.func_150891_b((Item)((Item)optItemType.get())), ((Block)blockState.getType()).func_176201_c((IBlockState)blockState)};
                } else {
                    ItemStackSnapshot snapshot = defaultSnapshot.get();
                    extra = new int[]{Item.func_150891_b((Item)((Item)snapshot.getType())), ((SpongeItemStackSnapshot)snapshot).getDamageValue()};
                }
            }
        }
        if (extra == null) {
            extra = new int[]{};
        }
        if ((defaultScale = type.getDefaultOption(ParticleOptions.SCALE)).isPresent()) {
            double scale = effect.getOption(ParticleOptions.SCALE).orElse(defaultScale.get());
            if (internal == EnumParticleTypes.EXPLOSION_LARGE || internal == EnumParticleTypes.SWEEP_ATTACK) {
                scale = -scale * 2.0 + 2.0;
            }
            if (scale == 0.0) {
                return new CachedParticlePacket(internal, offset, quantity, extra);
            }
            f0 = scale;
        } else {
            Optional<Color> defaultColor = type.getDefaultOption(ParticleOptions.COLOR);
            if (defaultColor.isPresent()) {
                boolean isSpell;
                Color color = effect.getOption(ParticleOptions.COLOR).orElse(null);
                boolean bl = isSpell = internal == EnumParticleTypes.SPELL_MOB || internal == EnumParticleTypes.SPELL_MOB_AMBIENT;
                if (!isSpell && (color == null || color.equals(defaultColor.get()))) {
                    return new CachedParticlePacket(internal, offset, quantity, extra);
                }
                if (isSpell && color == null) {
                    color = defaultColor.get();
                }
                f0 = (float)color.getRed() / 255.0f;
                f1 = (float)color.getGreen() / 255.0f;
                f2 = (float)color.getBlue() / 255.0f;
                if (isSpell) {
                    f0 = Math.max(f0, (double)0.001f);
                    f2 = Math.max(f0, (double)0.001f);
                }
                if (f0 == 0.0 && internal == EnumParticleTypes.REDSTONE) {
                    f0 = 1.0E-5f;
                }
            } else {
                Optional<NotePitch> defaultNote = type.getDefaultOption(ParticleOptions.NOTE);
                if (defaultNote.isPresent()) {
                    NotePitch notePitch = effect.getOption(ParticleOptions.NOTE).orElse(defaultNote.get());
                    float note = ((SpongeNotePitch)notePitch).getByteId();
                    if (note == 0.0f) {
                        return new CachedParticlePacket(internal, offset, quantity, extra);
                    }
                    f0 = note / 24.0f;
                } else {
                    Optional<Vector3d> defaultVelocity = type.getDefaultOption(ParticleOptions.VELOCITY);
                    if (defaultVelocity.isPresent()) {
                        Vector3d velocity = effect.getOption(ParticleOptions.VELOCITY).orElse(defaultVelocity.get());
                        f0 = velocity.getX();
                        f1 = velocity.getY();
                        f2 = velocity.getZ();
                        Optional<Boolean> slowHorizontalVelocity = type.getDefaultOption(ParticleOptions.SLOW_HORIZONTAL_VELOCITY);
                        if (slowHorizontalVelocity.isPresent() && effect.getOption(ParticleOptions.SLOW_HORIZONTAL_VELOCITY).orElse(slowHorizontalVelocity.get()).booleanValue()) {
                            f0 = 0.0;
                            f2 = 0.0;
                        }
                        if (internal == EnumParticleTypes.WATER_SPLASH) {
                            f1 = 0.0;
                        }
                        if (f0 == 0.0 && f1 == 0.0 && f2 == 0.0) {
                            return new CachedParticlePacket(internal, offset, quantity, extra);
                        }
                    }
                }
            }
        }
        if (f0 != 0.0 || f1 != 0.0 || f2 != 0.0) return new CachedOffsetParticlePacket(internal, new Vector3f(f0, f1, f2), offset, quantity, extra);
        return new CachedParticlePacket(internal, offset, quantity, extra);
    }

    private SpongeParticleHelper() {
    }

    private static final class CachedEffectPacket
    implements ICachedParticleEffect {
        private final int type;
        private final int data;
        private final boolean broadcast;

        private CachedEffectPacket(int type, int data, boolean broadcast) {
            this.broadcast = broadcast;
            this.type = type;
            this.data = data;
        }

        @Override
        public void process(Vector3d position, List<Packet<?>> output) {
            BlockPos blockPos = new BlockPos(position.getFloorX(), position.getFloorY(), position.getFloorZ());
            output.add((Packet<?>)new SPacketEffect(this.type, blockPos, this.data, this.broadcast));
        }
    }

    private static final class CachedOffsetParticlePacket
    implements ICachedParticleEffect {
        private final EnumParticleTypes particleType;
        private final Vector3f offsetData;
        private final Vector3f offset;
        private final int quantity;
        private final int[] extra;

        private CachedOffsetParticlePacket(EnumParticleTypes particleType, Vector3f offsetData, Vector3f offset, int quantity, int[] extra) {
            this.particleType = particleType;
            this.offsetData = offsetData;
            this.quantity = quantity;
            this.offset = offset;
            this.extra = extra;
        }

        @Override
        public void process(Vector3d position, List<Packet<?>> output) {
            float px = (float)position.getX();
            float py = (float)position.getY();
            float pz = (float)position.getZ();
            float odx = this.offsetData.getX();
            float ody = this.offsetData.getY();
            float odz = this.offsetData.getZ();
            if (this.offset.equals(Vector3f.ZERO)) {
                SPacketParticles message = new SPacketParticles(this.particleType, true, px, py, pz, odx, ody, odz, 1.0f, 0, this.extra);
                for (int i = 0; i < this.quantity; ++i) {
                    output.add((Packet<?>)message);
                }
            } else {
                Random random = new Random();
                float ox = this.offset.getX();
                float oy = this.offset.getY();
                float oz = this.offset.getZ();
                for (int i = 0; i < this.quantity; ++i) {
                    float px0 = px + (random.nextFloat() * 2.0f - 1.0f) * ox;
                    float py0 = py + (random.nextFloat() * 2.0f - 1.0f) * oy;
                    float pz0 = pz + (random.nextFloat() * 2.0f - 1.0f) * oz;
                    SPacketParticles message = new SPacketParticles(this.particleType, true, px0, py0, pz0, odx, ody, odz, 1.0f, 0, this.extra);
                    output.add((Packet<?>)message);
                }
            }
        }
    }

    private static final class CachedParticlePacket
    implements ICachedParticleEffect {
        private final EnumParticleTypes particleType;
        private final Vector3f offset;
        private final int quantity;
        private final int[] extra;

        private CachedParticlePacket(EnumParticleTypes particleType, Vector3f offset, int quantity, int[] extra) {
            this.particleType = particleType;
            this.quantity = quantity;
            this.offset = offset;
            this.extra = extra;
        }

        @Override
        public void process(Vector3d position, List<Packet<?>> output) {
            float px = (float)position.getX();
            float py = (float)position.getY();
            float pz = (float)position.getZ();
            float odx = this.offset.getX();
            float ody = this.offset.getY();
            float odz = this.offset.getZ();
            SPacketParticles message = new SPacketParticles(this.particleType, true, px, py, pz, odx, ody, odz, 0.0f, this.quantity, this.extra);
            output.add((Packet<?>)message);
        }
    }

    private static final class CachedFireworkPacket
    implements ICachedParticleEffect {
        private static final int FIREWORK_ROCKET_ID = Entity.field_70152_a++;
        private static final UUID FIREWORK_ROCKET_UNIQUE_ID = MathHelper.func_180182_a((Random)new Random());
        private static final SPacketDestroyEntities DESTROY_FIREWORK_ROCKET_DUMMY = new SPacketDestroyEntities(new int[]{FIREWORK_ROCKET_ID});
        private static final SPacketEntityStatus FIREWORK_ROCKET_DUMMY_EFFECT = new SPacketEntityStatus();
        private final SPacketEntityMetadata entityMetadataPacket;

        private CachedFireworkPacket(SPacketEntityMetadata entityMetadataPacket) {
            this.entityMetadataPacket = entityMetadataPacket;
        }

        @Override
        public void process(Vector3d position, List<Packet<?>> output) {
            SPacketSpawnObject packetSpawnObject = new SPacketSpawnObject();
            packetSpawnObject.field_149018_a = FIREWORK_ROCKET_ID;
            packetSpawnObject.field_186883_b = FIREWORK_ROCKET_UNIQUE_ID;
            packetSpawnObject.field_149016_b = position.getX();
            packetSpawnObject.field_149017_c = position.getY();
            packetSpawnObject.field_149014_d = position.getZ();
            packetSpawnObject.field_149019_j = 76;
            output.add((Packet<?>)packetSpawnObject);
            output.add((Packet<?>)this.entityMetadataPacket);
            output.add((Packet<?>)FIREWORK_ROCKET_DUMMY_EFFECT);
            output.add((Packet<?>)DESTROY_FIREWORK_ROCKET_DUMMY);
        }

        static {
            CachedFireworkPacket.FIREWORK_ROCKET_DUMMY_EFFECT.field_149164_a = FIREWORK_ROCKET_ID;
            CachedFireworkPacket.FIREWORK_ROCKET_DUMMY_EFFECT.field_149163_b = (byte)17;
        }
    }

    private static final class EmptyCachedPacket
    implements ICachedParticleEffect {
        public static final EmptyCachedPacket INSTANCE = new EmptyCachedPacket();

        private EmptyCachedPacket() {
        }

        @Override
        public void process(Vector3d position, List<Packet<?>> output) {
        }
    }
}

