/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.effect.particle;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.util.EnumParticleTypes;
import org.spongepowered.api.effect.particle.ParticleOption;
import org.spongepowered.api.effect.particle.ParticleType;
import org.spongepowered.common.SpongeCatalogType;

public class SpongeParticleType
extends SpongeCatalogType
implements ParticleType {
    private final String name;
    @Nullable
    private final EnumParticleTypes internalType;
    private final Map<ParticleOption<?>, Object> options;

    public SpongeParticleType(String id, String name, @Nullable EnumParticleTypes internalType, Map<ParticleOption<?>, Object> options) {
        super(id);
        this.options = ImmutableMap.copyOf(options);
        this.internalType = internalType;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Nullable
    public EnumParticleTypes getInternalType() {
        return this.internalType;
    }

    @Override
    protected MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().omitNullValues().add("internalType", (Object)this.internalType);
    }

    @Override
    public <V> Optional<V> getDefaultOption(ParticleOption<V> option) {
        return Optional.ofNullable(this.options.get(option));
    }

    @Override
    public Map<ParticleOption<?>, Object> getDefaultOptions() {
        return this.options;
    }
}

