/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.effect.potion;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.effect.potion.PotionEffect;
import org.spongepowered.api.effect.potion.PotionEffectType;
import org.spongepowered.common.data.util.DataQueries;

public class SpongePotionBuilder
extends AbstractDataBuilder<org.spongepowered.api.effect.potion.PotionEffect>
implements PotionEffect.Builder {
    private PotionEffectType potionType;
    private int duration;
    private int amplifier;
    private boolean isAmbient;
    private boolean showParticles;

    public SpongePotionBuilder() {
        super(org.spongepowered.api.effect.potion.PotionEffect.class, 1);
    }

    @Override
    public PotionEffect.Builder from(org.spongepowered.api.effect.potion.PotionEffect holder) {
        this.potionType = ((org.spongepowered.api.effect.potion.PotionEffect)Preconditions.checkNotNull((Object)holder)).getType();
        this.duration = holder.getDuration();
        this.amplifier = holder.getAmplifier();
        this.isAmbient = holder.isAmbient();
        this.showParticles = holder.getShowParticles();
        return this;
    }

    @Override
    protected Optional<org.spongepowered.api.effect.potion.PotionEffect> buildContent(DataView container) throws InvalidDataException {
        Preconditions.checkNotNull((Object)container);
        if (!(container.contains(DataQueries.POTION_TYPE) && container.contains(DataQueries.POTION_DURATION) && container.contains(DataQueries.POTION_AMPLIFIER) && container.contains(DataQueries.POTION_AMBIANCE) && container.contains(DataQueries.POTION_SHOWS_PARTICLES))) {
            return Optional.empty();
        }
        String effectName = container.getString(DataQueries.POTION_TYPE).get();
        Optional<PotionEffectType> optional = Sponge.getRegistry().getType(PotionEffectType.class, effectName);
        if (!optional.isPresent()) {
            throw new InvalidDataException("The container has an invalid potion type name: " + effectName);
        }
        int duration = container.getInt(DataQueries.POTION_DURATION).get();
        int amplifier = container.getInt(DataQueries.POTION_AMPLIFIER).get();
        boolean ambience = container.getBoolean(DataQueries.POTION_AMBIANCE).get();
        boolean particles = container.getBoolean(DataQueries.POTION_SHOWS_PARTICLES).get();
        SpongePotionBuilder builder = new SpongePotionBuilder();
        return Optional.of(builder.potionType(optional.get()).particles(particles).duration(duration).amplifier(amplifier).ambience(ambience).build());
    }

    @Override
    public PotionEffect.Builder potionType(PotionEffectType potionEffectType) {
        Preconditions.checkNotNull((Object)potionEffectType, (Object)"Potion effect type cannot be null");
        this.potionType = potionEffectType;
        return this;
    }

    @Override
    public PotionEffect.Builder duration(int duration) {
        Preconditions.checkArgument((duration > 0 ? 1 : 0) != 0, (Object)"Duration must be greater than 0");
        this.duration = duration;
        return this;
    }

    @Override
    public PotionEffect.Builder amplifier(int amplifier) throws IllegalArgumentException {
        Preconditions.checkArgument((amplifier >= 0 ? 1 : 0) != 0, (Object)"Amplifier must not be negative");
        this.amplifier = amplifier;
        return this;
    }

    @Override
    public PotionEffect.Builder ambience(boolean ambience) {
        this.isAmbient = ambience;
        return this;
    }

    @Override
    public PotionEffect.Builder particles(boolean showsParticles) {
        this.showParticles = showsParticles;
        return this;
    }

    @Override
    public org.spongepowered.api.effect.potion.PotionEffect build() throws IllegalStateException {
        Preconditions.checkState((this.potionType != null ? 1 : 0) != 0, (Object)"Potion type has not been set");
        Preconditions.checkState((this.duration > 0 ? 1 : 0) != 0, (Object)"Duration has not been set");
        return (org.spongepowered.api.effect.potion.PotionEffect)new PotionEffect((Potion)this.potionType, this.duration, this.amplifier, this.isAmbient, this.showParticles);
    }

    @Override
    public PotionEffect.Builder reset() {
        this.potionType = null;
        this.amplifier = 0;
        this.duration = 0;
        this.isAmbient = true;
        this.showParticles = true;
        return this;
    }
}

