/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.block.BlockPhaseState;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;

final class PistonMovingPhaseState
extends BlockPhaseState {
    PistonMovingPhaseState() {
    }

    @Override
    void unwind(PhaseContext phaseContext) {
        List<BlockSnapshot> capturedBlocks = phaseContext.getCapturedBlocks();
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            if (!TrackingUtil.processBlockCaptures(capturedBlocks, this, phaseContext)) {
                // empty if block
            }
            LocatableBlock locatable = phaseContext.getSource(LocatableBlock.class).orElseThrow(TrackingUtil.throwWithContext("Could not find a piston locatable block!", phaseContext));
            Sponge.getCauseStackManager().pushCause(locatable);
            phaseContext.addNotifierAndOwnerToCauseStack();
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.PLACEMENT);
            phaseContext.getCapturedItemsSupplier().ifPresentAndNotEmpty(items -> {
                ArrayList<org.spongepowered.api.entity.Entity> entities = new ArrayList<org.spongepowered.api.entity.Entity>();
                for (EntityItem item : items) {
                    entities.add(EntityUtil.fromNative((Entity)item));
                }
                DropItemEvent.Destruct event = SpongeEventFactory.createDropItemEventDestruct(Sponge.getCauseStackManager().getCurrentCause(), entities);
                SpongeImpl.postEvent(event);
                if (!event.isCancelled()) {
                    for (org.spongepowered.api.entity.Entity entity : event.getEntities()) {
                        EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                    }
                }
            });
            phaseContext.getCapturedEntitySupplier().ifPresentAndNotEmpty(entities -> {
                SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), entities);
                SpongeImpl.postEvent(event);
                User user = phaseContext.getNotifier().orElseGet(() -> phaseContext.getOwner().orElse(null));
                if (!event.isCancelled()) {
                    for (org.spongepowered.api.entity.Entity entity : event.getEntities()) {
                        if (user != null) {
                            EntityUtil.toMixin(entity).setCreator(user.getUniqueId());
                        }
                        EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                    }
                }
            });
        }
    }
}

