/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.general;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.world.ExplosionEvent;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.general.GeneralState;
import org.spongepowered.common.interfaces.world.IMixinLocation;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.BlockChange;

final class ExplosionState
extends GeneralState {
    ExplosionState() {
    }

    @Override
    public boolean canSwitchTo(IPhaseState state) {
        return true;
    }

    @Override
    public boolean tracksEntitySpecificDrops() {
        return true;
    }

    @Override
    public boolean tracksBlockSpecificDrops() {
        return true;
    }

    @Override
    public boolean requiresBlockPosTracking() {
        return true;
    }

    @Override
    void unwind(PhaseContext context) {
        Explosion explosion = context.getRequiredExtra("Explosion", Explosion.class);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            context.addNotifierAndOwnerToCauseStack();
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.TNT_IGNITE);
            Sponge.getCauseStackManager().pushCause(explosion);
            context.getCapturedBlockSupplier().ifPresentAndNotEmpty(blocks -> this.processBlockCaptures((List<BlockSnapshot>)blocks, explosion, context));
            context.getCapturedEntitySupplier().ifPresentAndNotEmpty(entities -> {
                User user = context.getNotifier().orElseGet(() -> context.getOwner().orElse(null));
                SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), entities);
                SpongeImpl.postEvent(event);
                if (!event.isCancelled()) {
                    for (org.spongepowered.api.entity.Entity entity : event.getEntities()) {
                        if (user != null) {
                            EntityUtil.toMixin(entity).setCreator(user.getUniqueId());
                        }
                        EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                    }
                }
            });
        }
    }

    private void processBlockCaptures(List<BlockSnapshot> snapshots, Explosion explosion, PhaseContext context) {
        if (snapshots.isEmpty()) {
            return;
        }
        ImmutableList[] transactionArrays = new ImmutableList[5];
        ImmutableList.Builder[] transactionBuilders = new ImmutableList.Builder[5];
        for (int i = 0; i < 5; ++i) {
            transactionBuilders[i] = new ImmutableList.Builder();
        }
        ArrayList<ChangeBlockEvent> blockEvents = new ArrayList<ChangeBlockEvent>();
        for (BlockSnapshot snapshot : snapshots) {
            TrackingUtil.TRANSACTION_PROCESSOR.apply(transactionBuilders).accept(TrackingUtil.TRANSACTION_CREATION.apply(snapshot));
        }
        for (int i = 0; i < 5; ++i) {
            transactionArrays[i] = transactionBuilders[i].build();
        }
        ChangeBlockEvent[] mainEvents = new ChangeBlockEvent[BlockChange.values().length];
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            try {
                this.getPhase().associateAdditionalCauses(this, context);
            }
            catch (Exception exception) {
                // empty catch block
            }
            TrackingUtil.iterateChangeBlockEvents(transactionArrays, blockEvents, mainEvents);
            for (BlockChange blockChange : BlockChange.values()) {
                ChangeBlockEvent mainEvent = mainEvents[blockChange.ordinal()];
                if (mainEvent == null) continue;
                Sponge.getCauseStackManager().pushCause(mainEvent);
            }
            ImmutableList transactions = transactionArrays[4];
            ExplosionEvent.Post postEvent = SpongeEventFactory.createExplosionEventPost(Sponge.getCauseStackManager().getCurrentCause(), explosion, (List)transactions);
            if (postEvent == null) {
                return;
            }
            SpongeImpl.postEvent(postEvent);
            ArrayList<Transaction> invalid = new ArrayList<Transaction>();
            boolean noCancelledTransactions = true;
            for (ChangeBlockEvent changeBlockEvent : blockEvents) {
                if (!changeBlockEvent.isCancelled()) continue;
                noCancelledTransactions = false;
                for (Transaction transaction : Lists.reverse(changeBlockEvent.getTransactions())) {
                    transaction.setValid(false);
                }
            }
            if (postEvent.isCancelled()) {
                noCancelledTransactions = false;
                for (Transaction transaction : postEvent.getTransactions()) {
                    transaction.setValid(false);
                }
            }
            for (Transaction transaction : postEvent.getTransactions()) {
                if (transaction.isValid()) continue;
                invalid.add(transaction);
                BlockPos blockPos = ((IMixinLocation)((Object)((BlockSnapshot)transaction.getOriginal()).getLocation().get())).getBlockPos();
                context.getBlockItemDropSupplier().ifPresentAndNotEmpty(map -> {
                    if (map.containsKey((Object)blockPos)) {
                        map.get((Object)blockPos).clear();
                    }
                });
                context.getBlockEntitySpawnSupplier().ifPresentAndNotEmpty(map -> {
                    if (map.containsKey((Object)blockPos)) {
                        map.get((Object)blockPos).clear();
                    }
                });
                context.getBlockEntitySpawnSupplier().ifPresentAndNotEmpty(blockPosEntityMultimap -> {
                    if (blockPosEntityMultimap.containsKey((Object)blockPos)) {
                        blockPosEntityMultimap.get((Object)blockPos).clear();
                    }
                });
            }
            if (!invalid.isEmpty()) {
                noCancelledTransactions = false;
                for (Transaction transaction : Lists.reverse(invalid)) {
                    ((BlockSnapshot)transaction.getOriginal()).restore(true, BlockChangeFlag.NONE);
                    if (!this.tracksBlockSpecificDrops()) continue;
                    BlockPos position = ((IMixinLocation)((Object)((BlockSnapshot)transaction.getOriginal()).getLocation().get())).getBlockPos();
                    context.getBlockDropSupplier().ifPresentAndNotEmpty(map -> {
                        if (map.containsKey((Object)position)) {
                            map.get((Object)position).clear();
                        }
                    });
                }
            }
            TrackingUtil.performBlockAdditions(postEvent.getTransactions(), this, context, noCancelledTransactions);
        }
    }

    @Override
    public boolean shouldCaptureBlockChangeOrSkip(PhaseContext phaseContext, BlockPos pos) {
        boolean match = false;
        Vector3i blockPos = VecHelper.toVector3i(pos);
        for (BlockSnapshot capturedSnapshot : phaseContext.getCapturedBlocks()) {
            if (!capturedSnapshot.getPosition().equals(blockPos)) continue;
            match = true;
        }
        return !match;
    }

    @Override
    public boolean spawnEntityOrCapture(PhaseContext context, org.spongepowered.api.entity.Entity entity, int chunkX, int chunkZ) {
        return context.getBlockPosition().map(blockPos -> {
            ListMultimap<BlockPos, Entity> blockPosEntityMultimap = context.getBlockEntitySpawnSupplier().get();
            ListMultimap<BlockPos, EntityItem> blockPosEntityItemMultimap = context.getBlockItemDropSupplier().get();
            if (entity instanceof EntityItem) {
                blockPosEntityItemMultimap.put(blockPos, (Object)((EntityItem)entity));
            } else {
                blockPosEntityMultimap.put(blockPos, (Object)((Entity)entity));
            }
            return true;
        }).orElseGet(() -> {
            ArrayList<org.spongepowered.api.entity.Entity> entities = new ArrayList<org.spongepowered.api.entity.Entity>(1);
            entities.add(entity);
            SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), entities);
            SpongeImpl.postEvent(event);
            if (!event.isCancelled() && event.getEntities().size() > 0) {
                for (org.spongepowered.api.entity.Entity item : event.getEntities()) {
                    ((IMixinWorldServer)((Object)item.getWorld())).forceSpawnEntity(item);
                }
                return true;
            }
            return false;
        });
    }
}

