/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerTryUseItemOnBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketState;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.block.IMixinBlockEventData;
import org.spongepowered.common.interfaces.world.IMixinLocation;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.registry.type.ItemTypeRegistryModule;
import org.spongepowered.common.world.BlockChange;

class PlaceBlockPacketState
extends BasicPacketState {
    PlaceBlockPacketState() {
    }

    @Override
    public boolean isInteraction() {
        return true;
    }

    @Override
    public void populateContext(EntityPlayerMP playerMP, Packet<?> packet, PhaseContext context) {
        CPacketPlayerTryUseItemOnBlock placeBlock = (CPacketPlayerTryUseItemOnBlock)packet;
        net.minecraft.item.ItemStack itemUsed = playerMP.func_184586_b(placeBlock.func_187022_c());
        ItemStack itemstack = ItemStackUtil.cloneDefensive(itemUsed);
        if (itemstack != null) {
            context.addExtra("ItemUsed", itemstack);
        } else {
            context.addExtra("ItemUsed", ItemTypeRegistryModule.NONE);
        }
        context.addBlockCaptures().addEntityCaptures().addEntityDropCaptures();
    }

    @Override
    public void handleBlockChangeWithUser(@Nullable BlockChange blockChange, Transaction<BlockSnapshot> transaction, PhaseContext context) {
        Player player = Sponge.getCauseStackManager().getCurrentCause().first(Player.class).get();
        Location<World> location = transaction.getFinal().getLocation().get();
        BlockPos pos = ((IMixinLocation)((Object)location)).getBlockPos();
        IMixinChunk spongeChunk = (IMixinChunk)((WorldServer)location.getExtent()).func_175726_f(pos);
        if (blockChange == BlockChange.PLACE) {
            spongeChunk.addTrackedBlockPosition((Block)transaction.getFinal().getState().getType(), pos, player, PlayerTracker.Type.OWNER);
        }
        spongeChunk.addTrackedBlockPosition((Block)transaction.getFinal().getState().getType(), pos, player, PlayerTracker.Type.NOTIFIER);
    }

    @Override
    public void associateBlockEventNotifier(PhaseContext context, IMixinWorldServer mixinWorldServer, BlockPos pos, IMixinBlockEventData blockEvent) {
        Player player = Sponge.getCauseStackManager().getCurrentCause().first(Player.class).get();
        Location<World> location = new Location<World>(player.getWorld(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        LocatableBlock locatableBlock = LocatableBlock.builder().location(location).state(location.getBlock()).build();
        blockEvent.setTickBlock(locatableBlock);
        blockEvent.setSourceUser(player);
    }
}

