/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.plugin;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.plugin.ListenerPhaseState;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.event.forge.IMixinWorldTickEvent;

final class PreWorldTickListenerState
extends ListenerPhaseState {
    PreWorldTickListenerState() {
    }

    @Override
    public void processPostTick(PhaseContext phaseContext) {
        IMixinWorldTickEvent worldTickEvent = phaseContext.getRequiredExtra("CapturedWorldTickEvent", IMixinWorldTickEvent.class);
        Object listener = phaseContext.getSource(Object.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be capturing a WorldTickEvent listener!", phaseContext));
        phaseContext.getCapturedBlockSupplier().ifPresentAndNotEmpty(blocks -> TrackingUtil.processBlockCaptures(blocks, this, phaseContext));
    }

    @Override
    public void associateNeighborBlockNotifier(PhaseContext context, @Nullable BlockPos sourcePos, Block block, BlockPos notifyPos, WorldServer minecraftWorld, PlayerTracker.Type notifier) {
        context.getCapturedPlayer().ifPresent(player -> ((IMixinChunk)minecraftWorld.func_175726_f(notifyPos)).setBlockNotifier(notifyPos, player.getUniqueId()));
    }

    @Override
    public void capturePlayerUsingStackToBreakBlocks(PhaseContext context, EntityPlayerMP playerMP, @Nullable ItemStack stack) {
        context.getCapturedPlayerSupplier().addPlayer(playerMP);
    }
}

