/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.extra.fluid;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.extra.fluid.FluidStack;
import org.spongepowered.api.extra.fluid.FluidStackSnapshot;
import org.spongepowered.api.extra.fluid.FluidType;
import org.spongepowered.common.data.util.DataQueries;
import org.spongepowered.common.extra.fluid.SpongeFluidStackSnapshot;

public class SpongeFluidStackSnapshotBuilder
extends AbstractDataBuilder<FluidStackSnapshot>
implements FluidStackSnapshot.Builder {
    FluidType fluidType;
    int volume;
    @Nullable
    DataView container;

    public SpongeFluidStackSnapshotBuilder() {
        super(FluidStackSnapshot.class, 1);
    }

    @Override
    public FluidStackSnapshot.Builder fluid(FluidType fluidType) {
        this.fluidType = (FluidType)Preconditions.checkNotNull((Object)fluidType, (Object)"FluidType cannot be null!");
        return this;
    }

    @Override
    public FluidStackSnapshot.Builder volume(int volume) {
        this.volume = volume;
        return this;
    }

    @Override
    public FluidStackSnapshot.Builder from(FluidStack fluidStack) {
        this.fluidType = fluidStack.getFluid();
        this.volume = fluidStack.getVolume();
        DataContainer datacontainer = fluidStack.toContainer();
        this.container = null;
        if (datacontainer.contains(DataQueries.UNSAFE_NBT)) {
            this.container = datacontainer.getView(DataQueries.UNSAFE_NBT).get();
        }
        return this;
    }

    @Override
    public FluidStackSnapshot.Builder add(DataManipulator<?, ?> manipulator) {
        return this;
    }

    @Override
    public FluidStackSnapshot.Builder add(ImmutableDataManipulator<?, ?> manipulator) {
        return this;
    }

    @Override
    public <V> FluidStackSnapshot.Builder add(Key<? extends BaseValue<V>> key, V value) {
        return this;
    }

    @Override
    public FluidStackSnapshot.Builder from(FluidStackSnapshot holder) {
        Preconditions.checkNotNull((Object)holder, (Object)"FluidStackSnapshot cannot be null!");
        this.fluidType = (FluidType)Preconditions.checkNotNull((Object)holder.getFluid(), (Object)"Invalid FluidStackSnapshot! FluidType cannot be null!");
        return null;
    }

    @Override
    public FluidStackSnapshot build() {
        Preconditions.checkState((this.fluidType != null ? 1 : 0) != 0, (Object)"FluidType cannot be null!");
        Preconditions.checkState((this.volume >= 0 ? 1 : 0) != 0, (Object)"The fluid volume must be at least 0!");
        return new SpongeFluidStackSnapshot(this);
    }

    @Override
    protected Optional<FluidStackSnapshot> buildContent(DataView container) throws InvalidDataException {
        try {
            if (container.contains(DataQueries.FLUID_TYPE, DataQueries.FLUID_VOLUME)) {
                String fluidId = container.getString(DataQueries.FLUID_TYPE).get();
                Optional<FluidType> type = Sponge.getRegistry().getType(FluidType.class, fluidId);
                if (!type.isPresent()) {
                    throw new InvalidDataException("Unknown fluid id found: " + fluidId);
                }
                FluidType fluidType = type.get();
                int volume = container.getInt(DataQueries.FLUID_VOLUME).get();
                SpongeFluidStackSnapshotBuilder builder = new SpongeFluidStackSnapshotBuilder();
                builder.fluid(fluidType).volume(volume);
                if (container.contains(DataQueries.UNSAFE_NBT)) {
                    builder.container = container.getView(DataQueries.UNSAFE_NBT).get().copy();
                }
                return Optional.of(builder.build());
            }
        }
        catch (Exception e) {
            throw new InvalidDataException("Something went wrong deserializing.", e);
        }
        return Optional.empty();
    }

    @Override
    public FluidStackSnapshot.Builder reset() {
        this.fluidType = null;
        this.volume = 0;
        this.container = null;
        return this;
    }
}

