/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.lens.impl;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.property.SlotIndex;
import org.spongepowered.common.item.inventory.adapter.impl.Adapter;
import org.spongepowered.common.item.inventory.lens.CompoundSlotProvider;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.impl.MinecraftLens;

public class CompoundLens
extends MinecraftLens {
    protected final List<Lens<IInventory, ItemStack>> inventories;

    private CompoundLens(int size, Class<? extends Inventory> adapterType, SlotProvider<IInventory, ItemStack> slots, List<Lens<IInventory, ItemStack>> lenses) {
        super(0, size, adapterType, slots);
        this.inventories = lenses;
        this.init(slots);
    }

    @Override
    protected void init(SlotProvider<IInventory, ItemStack> slots) {
        int ord = 0;
        int slot = this.base;
        while (ord < this.size) {
            if (!this.children.contains(slots.getSlot(slot))) {
                this.addSpanningChild(slots.getSlot(slot), new SlotIndex(ord));
            }
            ++ord;
            ++slot;
        }
    }

    @Override
    protected boolean isDelayedInit() {
        return true;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<Lens<IInventory, ItemStack>> lenses = new ArrayList<Lens<IInventory, ItemStack>>();

        public Builder add(Lens lens) {
            this.lenses.add(lens);
            return this;
        }

        public CompoundLens build(CompoundSlotProvider provider) {
            return new CompoundLens(provider.size(), Adapter.class, provider, this.lenses);
        }
    }
}

