/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.lens.impl.comp;

import com.google.common.base.Preconditions;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.data.Property;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.property.SlotIndex;
import org.spongepowered.api.item.inventory.property.SlotPos;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.comp.Inventory2DAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.comp.Inventory2DLens;
import org.spongepowered.common.item.inventory.lens.impl.comp.OrderedInventoryLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.struct.LensHandle;
import org.spongepowered.common.item.inventory.lens.slots.SlotLens;

public class Inventory2DLensImpl
extends OrderedInventoryLensImpl
implements Inventory2DLens<IInventory, ItemStack> {
    protected final int width;
    protected final int height;
    protected final int xBase;
    protected final int yBase;

    public Inventory2DLensImpl(int base, int width, int height, SlotProvider<IInventory, ItemStack> slots) {
        this(base, width, height, width, Inventory2DAdapter.class, slots);
    }

    public Inventory2DLensImpl(int base, int width, int height, Class<? extends Inventory> adapterType, SlotProvider<IInventory, ItemStack> slots) {
        this(base, width, height, width, adapterType, slots);
    }

    public Inventory2DLensImpl(int base, int width, int height, int rowStride, Class<? extends Inventory> adapterType, SlotProvider<IInventory, ItemStack> slots) {
        this(base, width, height, rowStride, 0, 0, adapterType, slots);
    }

    protected Inventory2DLensImpl(int base, int width, int height, int rowStride, int xBase, int yBase, Class<? extends Inventory> adapterType, SlotProvider<IInventory, ItemStack> slots) {
        super(base, width * height, rowStride, adapterType, slots);
        Preconditions.checkArgument((width > 0 ? 1 : 0) != 0, (String)"Invalid width: %s", (int)width);
        Preconditions.checkArgument((height > 0 ? 1 : 0) != 0, (String)"Invalid height: %s", (int)height);
        Preconditions.checkArgument((rowStride >= width ? 1 : 0) != 0, (String)"Invalid stride: stride=%s, width=%s", (int)rowStride, (int)width);
        this.width = width;
        this.height = height;
        this.xBase = xBase;
        this.yBase = yBase;
        this.init(null, slots);
    }

    @Override
    protected boolean isDelayedInit() {
        return true;
    }

    @Override
    protected void init(SlotProvider<IInventory, ItemStack> slots) {
        this.init(slots, true);
    }

    protected void init(SlotProvider<IInventory, ItemStack> slots, boolean spanning) {
        int y = 0;
        int ord = 0;
        int slot = this.base;
        while (y < this.height) {
            int x = 0;
            while (x < this.width) {
                SlotLens<IInventory, ItemStack> slotLens = slots.getSlot(slot);
                if (spanning) {
                    this.addSpanningChild(slotLens, new SlotIndex(ord), new SlotPos(this.xBase + x, this.yBase + y));
                } else {
                    this.addChild(slotLens, new SlotIndex(ord), new SlotPos(this.xBase + x, this.yBase + y));
                }
                ++x;
                ++slot;
                ++ord;
            }
            ++y;
            slot += this.stride - this.width;
        }
        super.cache();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public SlotLens<IInventory, ItemStack> getSlot(SlotPos pos) {
        if (pos.getOperator() != Property.Operator.EQUAL) {
            return null;
        }
        return (SlotLens)((LensHandle)this.spanningChildren.get((int)pos.getY())).lens.getLens(pos.getX());
    }

    @Override
    public int getRealIndex(Fabric<IInventory> inv, int ordinal) {
        if (!this.checkOrdinal(ordinal)) {
            return -1;
        }
        return this.base + ordinal / this.width * this.stride + ordinal % this.width;
    }

    @Override
    public InventoryAdapter<IInventory, ItemStack> getAdapter(Fabric<IInventory> inv, Inventory parent) {
        return new Inventory2DAdapter(inv, this, parent);
    }
}

