/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.lens.impl.minecraft;

import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.entity.ArmorEquipable;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.api.item.inventory.property.SlotIndex;
import org.spongepowered.common.entity.player.SpongeUserInventory;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.comp.EquipmentInventoryLens;
import org.spongepowered.common.item.inventory.lens.comp.MainPlayerInventoryLens;
import org.spongepowered.common.item.inventory.lens.impl.MinecraftLens;
import org.spongepowered.common.item.inventory.lens.impl.comp.EquipmentInventoryLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.comp.MainPlayerInventoryLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.comp.OrderedInventoryLensImpl;
import org.spongepowered.common.item.inventory.lens.slots.SlotLens;

public class PlayerInventoryLens
extends MinecraftLens {
    private static final int EQUIPMENT = 4;
    private static final int MAIN_INVENTORY_HEIGHT = 3;
    private static final int HOTBAR = 1;
    private final ArmorEquipable player;
    private MainPlayerInventoryLensImpl main;
    private EquipmentInventoryLensImpl equipment;
    private SlotLens<IInventory, ItemStack> offhand;

    public PlayerInventoryLens(InventoryAdapter<IInventory, ItemStack> adapter, SlotProvider<IInventory, ItemStack> slots) {
        super(0, adapter.getInventory().getSize(), adapter, slots);
        if (adapter instanceof InventoryPlayer) {
            this.player = (ArmorEquipable)((InventoryPlayer)adapter).field_70458_d;
        } else if (adapter instanceof SpongeUserInventory) {
            this.player = ((SpongeUserInventory)((Object)adapter)).player;
        } else {
            throw new IllegalArgumentException("Adapter is not a PlayerInventory");
        }
        this.init(slots);
    }

    @Override
    protected void init(SlotProvider<IInventory, ItemStack> slots) {
        int ord = 0;
        int slot = this.base;
        while (ord < this.size) {
            this.addChild(slots.getSlot(slot), new SlotIndex(ord));
            ++ord;
            ++slot;
        }
        int base = 0;
        int INVENTORY_WIDTH = InventoryPlayer.func_70451_h();
        this.main = new MainPlayerInventoryLensImpl(base, INVENTORY_WIDTH, 4, INVENTORY_WIDTH, slots);
        base += INVENTORY_WIDTH * 1;
        this.equipment = new EquipmentInventoryLensImpl(this.player, base += INVENTORY_WIDTH * 3, 4, 1, slots);
        this.offhand = slots.getSlot(base += 4);
        this.addSpanningChild(this.main, new InventoryProperty[0]);
        this.addSpanningChild(this.equipment, new InventoryProperty[0]);
        this.addSpanningChild(this.offhand, new InventoryProperty[0]);
        int additionalSlots = this.size - base;
        if (additionalSlots > 0) {
            this.addSpanningChild(new OrderedInventoryLensImpl(base, additionalSlots, 1, slots), new InventoryProperty[0]);
        }
    }

    @Override
    protected boolean isDelayedInit() {
        return true;
    }

    public MainPlayerInventoryLens<IInventory, ItemStack> getMainLens() {
        return this.main;
    }

    public EquipmentInventoryLens<IInventory, ItemStack> getEquipmentLens() {
        return this.equipment;
    }

    public SlotLens<IInventory, ItemStack> getOffhandLens() {
        return this.offhand;
    }
}

