/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.query.strategy;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Set;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.query.Query;
import org.spongepowered.common.item.inventory.query.QueryStrategy;

public final class CompoundStrategy<TInventory, TStack>
extends QueryStrategy<TInventory, TStack, Object> {
    private Set<QueryStrategy<TInventory, TStack, ?>> strategies = new HashSet();

    @Override
    public QueryStrategy<TInventory, TStack, Object> with(ImmutableSet<Object> objects) {
        Multimap args = Multimaps.newMultimap(new EnumMap(Query.Type.class), HashSet::new);
        for (Object arg : objects) {
            args.put((Object)Query.getType(arg), arg);
        }
        args.asMap().forEach(this::addStrategy);
        if (this.strategies.size() == 1) {
            QueryStrategy<TInventory, TStack, ?> value = this.strategies.iterator().next();
            return value;
        }
        return this;
    }

    private <E> void addStrategy(Query.Type type, Collection<E> args) {
        QueryStrategy strategy = Query.getStrategy(type);
        this.strategies.add(strategy.with(ImmutableSet.copyOf(args)));
    }

    @Override
    public boolean matches(Lens<TInventory, TStack> lens, Lens<TInventory, TStack> parent, Fabric<TInventory> inventory) {
        if (this.strategies.isEmpty()) {
            return true;
        }
        for (QueryStrategy<TInventory, TStack, ?> subStrategy : this.strategies) {
            if (!subStrategy.matches(lens, parent, inventory)) continue;
            return true;
        }
        return false;
    }
}

