/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.crafting;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import org.spongepowered.api.item.inventory.crafting.CraftingGridInventory;
import org.spongepowered.api.item.recipe.crafting.CraftingRecipe;
import org.spongepowered.api.item.recipe.crafting.CraftingRecipeRegistry;
import org.spongepowered.api.item.recipe.crafting.CraftingRecipes;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.item.recipe.crafting.DelegateSpongeCraftingRecipe;
import org.spongepowered.common.registry.RegistryHelper;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;

public class SpongeCraftingRecipeRegistry
implements CraftingRecipeRegistry,
SpongeAdditionalCatalogRegistryModule<CraftingRecipe> {
    @RegisterCatalog(value=CraftingRecipes.class)
    private final Map<String, CraftingRecipe> recipeMappings = new HashMap<String, CraftingRecipe>();
    private boolean registrationsComplete = false;
    private List<CraftingRecipe> customRecipes = new ArrayList<CraftingRecipe>();

    public static SpongeCraftingRecipeRegistry getInstance() {
        return Holder.INSTANCE;
    }

    private SpongeCraftingRecipeRegistry() {
    }

    @Override
    public void register(CraftingRecipe recipe) {
        Preconditions.checkNotNull((Object)recipe, (Object)"recipe");
        this.registerAdditionalCatalog(recipe);
    }

    @Override
    public Collection<CraftingRecipe> getRecipes() {
        return SpongeImplHooks.getCraftingRecipes();
    }

    @Override
    public Optional<CraftingRecipe> findMatchingRecipe(CraftingGridInventory inventory, World world) {
        return SpongeImplHooks.findMatchingRecipe(inventory, world);
    }

    @Override
    public boolean allowsApiRegistration() {
        return !this.registrationsComplete;
    }

    public void disableRegistrations() {
        this.registrationsComplete = true;
        this.registerCustomWithVanilla();
    }

    @Override
    public void registerDefaults() {
        for (IRecipe iRecipe : CraftingManager.field_193380_a) {
            CraftingRecipe recipe = (CraftingRecipe)iRecipe;
            this.recipeMappings.put(recipe.getId(), recipe);
        }
        RegistryHelper.setFinalStatic(org.spongepowered.api.item.recipe.crafting.Ingredient.class, "NONE", Ingredient.field_193370_a);
    }

    @Override
    public void registerAdditionalCatalog(CraftingRecipe recipe) {
        Preconditions.checkState((!this.registrationsComplete ? 1 : 0) != 0, (Object)"Cannot register additional Recipes at this time! Recipes can only be registered before Initialization!");
        if (!(recipe instanceof IRecipe)) {
            recipe = new DelegateSpongeCraftingRecipe(recipe);
        }
        this.recipeMappings.put(recipe.getId(), recipe);
        this.customRecipes.add(recipe);
    }

    @Override
    public Optional<CraftingRecipe> getById(String id) {
        return SpongeImplHooks.getRecipeById(id);
    }

    @Override
    public Collection<CraftingRecipe> getAll() {
        return this.getRecipes();
    }

    public List<CraftingRecipe> getCustomRecipes() {
        return this.customRecipes;
    }

    public void registerCustomWithVanilla() {
        for (CraftingRecipe customRecipe : this.customRecipes) {
            SpongeImplHooks.onCraftingRecipeRegister(customRecipe);
        }
    }

    private static final class Holder {
        static final SpongeCraftingRecipeRegistry INSTANCE = new SpongeCraftingRecipeRegistry();

        private Holder() {
        }
    }
}

