/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.crafting;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.recipe.crafting.ShapelessCraftingRecipe;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.item.recipe.crafting.IngredientUtil;
import org.spongepowered.common.item.recipe.crafting.SpongeShapelessRecipe;

public class SpongeShapelessCraftingRecipeBuilder
implements ShapelessCraftingRecipe.Builder.EndStep,
ShapelessCraftingRecipe.Builder.ResultStep {
    private ItemStackSnapshot exemplaryResult = ItemStackSnapshot.NONE;
    private NonNullList<Ingredient> ingredients = NonNullList.func_191196_a();
    private String groupName = "";

    @Override
    public ShapelessCraftingRecipe.Builder.EndStep group(@Nullable String name) {
        this.groupName = name == null ? "" : name;
        return this;
    }

    @Override
    public ShapelessCraftingRecipe.Builder from(ShapelessCraftingRecipe value) {
        this.exemplaryResult = value.getExemplaryResult();
        if (this.exemplaryResult == null) {
            this.exemplaryResult = ItemStackSnapshot.NONE;
        }
        this.ingredients.clear();
        value.getIngredientPredicates().forEach(i -> this.ingredients.add((Object)IngredientUtil.toNative(i)));
        this.groupName = "";
        if (value instanceof ShapelessRecipes) {
            this.groupName = ((ShapelessRecipes)value).field_194138_c;
        }
        return this;
    }

    @Override
    public ShapelessCraftingRecipe.Builder reset() {
        this.exemplaryResult = ItemStackSnapshot.NONE;
        this.ingredients.clear();
        this.groupName = "";
        return this;
    }

    @Override
    public ShapelessCraftingRecipe.Builder.ResultStep addIngredient(org.spongepowered.api.item.recipe.crafting.Ingredient ingredient) {
        Preconditions.checkNotNull((Object)ingredient, (Object)"ingredient");
        this.ingredients.add((Object)IngredientUtil.toNative(ingredient));
        return this;
    }

    @Override
    public ShapelessCraftingRecipe.Builder.EndStep result(ItemStackSnapshot result) {
        Preconditions.checkNotNull((Object)result, (Object)"result");
        Preconditions.checkArgument((result != ItemStackSnapshot.NONE ? 1 : 0) != 0, (Object)"The result must not be `ItemStackSnapshot.NONE`.");
        this.exemplaryResult = result;
        return this;
    }

    @Override
    public ShapelessCraftingRecipe build(String id, Object plugin) {
        Preconditions.checkState((this.exemplaryResult != null && this.exemplaryResult != ItemStackSnapshot.NONE ? 1 : 0) != 0, (Object)"The result is not set.");
        Preconditions.checkState((!this.ingredients.isEmpty() ? 1 : 0) != 0, (Object)"The ingredients are not set.");
        Preconditions.checkNotNull((Object)id, (Object)"id");
        Preconditions.checkNotNull((Object)id, (Object)"plugin");
        PluginContainer container = SpongeImpl.getPluginContainer(plugin);
        if (!id.startsWith(container.getId() + ":")) {
            id = container.getId() + ":" + id;
        }
        return (ShapelessCraftingRecipe)((Object)new SpongeShapelessRecipe(id, this.groupName, ItemStackUtil.toNative(this.exemplaryResult.createStack()), this.ingredients));
    }
}

