/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block.state;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateBase;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.util.Cycleable;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.block.SpongeBlockSnapshotBuilder;
import org.spongepowered.common.data.util.DataQueries;
import org.spongepowered.common.interfaces.block.IMixinBlock;
import org.spongepowered.common.interfaces.block.IMixinBlockState;
import org.spongepowered.common.interfaces.data.IMixinCustomDataHolder;

@Mixin(value={BlockStateContainer.StateImplementation.class})
public abstract class MixinStateImplementation
extends BlockStateBase
implements BlockState,
IMixinBlockState {
    @Shadow
    @Final
    private Block field_177239_a;
    @Shadow
    @Final
    private ImmutableMap<IProperty<?>, Comparable<?>> field_177237_b;
    private ImmutableSet<ImmutableValue<?>> values;
    private ImmutableSet<Key<?>> keys;
    private ImmutableList<ImmutableDataManipulator<?, ?>> manipulators;
    private ImmutableMap<Key<?>, Object> keyMap;
    private String id;

    @Override
    public BlockState cycleValue(Key<? extends BaseValue<? extends Cycleable<?>>> key) {
        if (this.supports(key)) {
            Cycleable value = (Cycleable)this.get(key).get();
            Object next = value.cycleNext();
            return this.with(key, next).get();
        }
        throw new IllegalArgumentException("Used an invalid cyclable key! Check with supports in the future!");
    }

    @Override
    public BlockSnapshot snapshotFor(Location<World> location) {
        SpongeBlockSnapshotBuilder builder = new SpongeBlockSnapshotBuilder().blockState(this).position(location.getBlockPosition()).worldId(location.getExtent().getUniqueId());
        if (this.field_177239_a.func_149716_u() && location.getBlockType().equals(this.field_177239_a)) {
            org.spongepowered.api.block.tileentity.TileEntity tileEntity = location.getTileEntity().get();
            for (DataManipulator<?, ?> manipulator : ((IMixinCustomDataHolder)((Object)tileEntity)).getCustomManipulators()) {
                builder.add((DataManipulator)manipulator);
            }
            NBTTagCompound compound = new NBTTagCompound();
            ((TileEntity)tileEntity).func_189515_b(compound);
            builder.unsafeNbt(compound);
        }
        return builder.build();
    }

    @Override
    public List<ImmutableDataManipulator<?, ?>> getManipulators() {
        if (this.manipulators == null) {
            this.manipulators = ImmutableList.copyOf(((IMixinBlock)this.field_177239_a).getManipulators((IBlockState)this));
            this.populateKeyValues();
        }
        return this.manipulators;
    }

    @Override
    public <T extends ImmutableDataManipulator<?, ?>> Optional<T> get(Class<T> containerClass) {
        for (ImmutableDataManipulator<?, ?> manipulator : this.getManipulators()) {
            if (!containerClass.isInstance(manipulator)) continue;
            return Optional.of(manipulator);
        }
        return Optional.empty();
    }

    @Override
    public <T extends ImmutableDataManipulator<?, ?>> Optional<T> getOrCreate(Class<T> containerClass) {
        for (ImmutableDataManipulator<?, ?> manipulator : this.getManipulators()) {
            if (!containerClass.isInstance(manipulator)) continue;
            return Optional.of(manipulator);
        }
        return Optional.empty();
    }

    @Override
    public boolean supports(Class<? extends ImmutableDataManipulator<?, ?>> containerClass) {
        return ((IMixinBlock)this.field_177239_a).supports(containerClass);
    }

    @Override
    public <E> Optional<BlockState> transform(Key<? extends BaseValue<E>> key, Function<E, E> function) {
        if (!this.supports((Key)Preconditions.checkNotNull(key))) {
            return Optional.empty();
        }
        E current = this.get(key).get();
        Object newVal = Preconditions.checkNotNull(function.apply(current));
        return this.with(key, newVal);
    }

    @Override
    public <E> Optional<BlockState> with(Key<? extends BaseValue<E>> key, E value) {
        if (!this.supports(key)) {
            return Optional.empty();
        }
        return ((IMixinBlock)this.field_177239_a).getStateWithValue((IBlockState)this, key, value);
    }

    @Override
    public Optional<BlockState> with(BaseValue<?> value) {
        return this.with(value.getKey(), value.get());
    }

    @Override
    public Optional<BlockState> with(ImmutableDataManipulator<?, ?> valueContainer) {
        if (this.supports((Class<? extends ImmutableDataManipulator<?, ?>>)valueContainer.getClass())) {
            return ((IMixinBlock)this.field_177239_a).getStateWithData((IBlockState)this, valueContainer);
        }
        return Optional.empty();
    }

    @Override
    public Optional<BlockState> with(Iterable<ImmutableDataManipulator<?, ?>> valueContainers) {
        BlockState state = this;
        for (ImmutableDataManipulator<?, ?> manipulator : valueContainers) {
            Optional optional = state.with(manipulator);
            if (optional.isPresent()) {
                state = (BlockState)optional.get();
                continue;
            }
            return Optional.empty();
        }
        return Optional.of(state);
    }

    @Override
    public Optional<BlockState> without(Class<? extends ImmutableDataManipulator<?, ?>> containerClass) {
        return Optional.empty();
    }

    @Override
    public BlockState merge(BlockState that) {
        if (!this.getType().equals(that.getType())) {
            return this;
        }
        BlockState temp = this;
        for (ImmutableDataManipulator<?, ?> manipulator : that.getManipulators()) {
            Optional optional = temp.with(manipulator);
            if (optional.isPresent()) {
                temp = (BlockState)optional.get();
                continue;
            }
            return temp;
        }
        return temp;
    }

    @Override
    public BlockState merge(BlockState that, MergeFunction function) {
        if (!this.getType().equals(that.getType())) {
            return this;
        }
        BlockState temp = this;
        for (ImmutableDataManipulator<?, ?> manipulator : that.getManipulators()) {
            ImmutableDataManipulator old = temp.get(manipulator.getClass()).orElse(null);
            Optional optional = temp.with((ValueContainer)Preconditions.checkNotNull(function.merge(old, manipulator)));
            if (optional.isPresent()) {
                temp = (BlockState)optional.get();
                continue;
            }
            return temp;
        }
        return temp;
    }

    @Override
    public List<ImmutableDataManipulator<?, ?>> getContainers() {
        return this.getManipulators();
    }

    @Override
    public <E> Optional<E> get(Key<? extends BaseValue<E>> key) {
        if (this.keyMap == null) {
            this.populateKeyValues();
        }
        if (this.keyMap.containsKey(Preconditions.checkNotNull(key))) {
            return Optional.of(this.keyMap.get(key));
        }
        return Optional.empty();
    }

    private void populateKeyValues() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ImmutableSet.Builder keyBuilder = ImmutableSet.builder();
        ImmutableSet.Builder valueBuilder = ImmutableSet.builder();
        for (ImmutableDataManipulator<?, ?> manipulator : this.getManipulators()) {
            for (ImmutableValue<?> value : manipulator.getValues()) {
                builder.put(value.getKey(), value.get());
                valueBuilder.add(value);
                keyBuilder.add(value.getKey());
            }
        }
        this.values = valueBuilder.build();
        this.keys = keyBuilder.build();
        this.keyMap = builder.build();
    }

    @Override
    public <E, V extends BaseValue<E>> Optional<V> getValue(Key<V> key) {
        Preconditions.checkNotNull(key);
        for (ImmutableValue<?> value : this.getValues()) {
            if (!value.getKey().equals(key)) continue;
            return Optional.of(value.asMutable());
        }
        return Optional.empty();
    }

    @Override
    public boolean supports(Key<?> key) {
        return this.getKeys().contains(Preconditions.checkNotNull(key));
    }

    @Override
    public BlockState copy() {
        return this;
    }

    @Override
    public Set<Key<?>> getKeys() {
        if (this.keys == null) {
            this.populateKeyValues();
        }
        return this.keys;
    }

    @Override
    public Set<ImmutableValue<?>> getValues() {
        if (this.values == null) {
            this.populateKeyValues();
        }
        return this.values;
    }

    @Override
    public int getContentVersion() {
        return 2;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew().set(Queries.CONTENT_VERSION, (Object)this.getContentVersion()).set(DataQueries.BLOCK_STATE, (Object)this.getId());
    }

    @Override
    public int getStateMeta() {
        return this.field_177239_a.func_176201_c((IBlockState)this);
    }

    @Override
    public void generateId(Block block) {
        StringBuilder builder = new StringBuilder();
        builder.append(((BlockType)block).getId());
        if (!this.field_177237_b.isEmpty()) {
            builder.append('[');
            Joiner joiner = Joiner.on((char)',');
            ArrayList<String> propertyValues = new ArrayList<String>();
            for (Map.Entry entry : this.field_177237_b.entrySet()) {
                propertyValues.add(((IProperty)entry.getKey()).func_177701_a() + "=" + entry.getValue());
            }
            builder.append(joiner.join(propertyValues));
            builder.append(']');
        }
        this.id = builder.toString();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.id;
    }
}

