/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.item.inventory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.NonNullList;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.InventoryArchetype;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.interfaces.IMixinContainer;
import org.spongepowered.common.item.inventory.adapter.impl.MinecraftInventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.slots.SlotAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.impl.MinecraftFabric;
import org.spongepowered.common.item.inventory.lens.impl.collections.SlotCollection;
import org.spongepowered.common.item.inventory.util.ContainerUtil;

@NonnullByDefault
@Mixin(value={net.minecraft.inventory.Container.class}, priority=998)
@Implements(value={@Interface(iface=MinecraftInventoryAdapter.class, prefix="inventory$")})
public abstract class MixinContainer
implements Container,
IMixinContainer,
CarriedInventory<Carrier> {
    @Shadow
    public List<net.minecraft.inventory.Slot> field_75151_b;
    @Shadow
    public NonNullList<net.minecraft.item.ItemStack> field_75153_a;
    @Shadow
    public int field_75152_c;
    @Shadow
    protected List<IContainerListener> field_75149_d;
    private boolean spectatorChest;
    private boolean captureInventory = false;
    private List<SlotTransaction> capturedSlotTransactions = new ArrayList<SlotTransaction>();
    private Fabric<IInventory> fabric;
    private SlotCollection slots;
    private Lens<IInventory, net.minecraft.item.ItemStack> lens;
    private boolean initialized;
    private Map<Integer, SlotAdapter> adapters = new HashMap<Integer, SlotAdapter>();
    private InventoryArchetype archetype;
    protected Optional<Carrier> carrier = Optional.empty();
    protected Optional<Predicate<EntityPlayer>> canInteractWithPredicate = Optional.empty();
    @Nullable
    private PluginContainer plugin = null;

    @Shadow
    public abstract NonNullList<net.minecraft.item.ItemStack> func_75138_a();

    @Shadow
    public abstract net.minecraft.inventory.Slot func_75139_a(int var1);

    @Shadow
    public net.minecraft.item.ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        throw new IllegalStateException("Shadowed.");
    }

    private void init() {
        this.initialized = true;
        this.fabric = MinecraftFabric.of(this);
        this.slots = ContainerUtil.countSlots((net.minecraft.inventory.Container)this);
        this.lens = this.spectatorChest ? null : ContainerUtil.getLens(this.fabric, (net.minecraft.inventory.Container)this, this.slots);
        this.archetype = ContainerUtil.getArchetype((net.minecraft.inventory.Container)this);
        this.carrier = Optional.ofNullable(ContainerUtil.getCarrier(this));
        if (this.lens != null) {
            for (Slot slot : this.slots.getIterator(this, (MinecraftInventoryAdapter)((Object)this))) {
                this.adapters.put(((SlotAdapter)slot).slotNumber, (SlotAdapter)slot);
            }
        }
    }

    @Override
    public InventoryArchetype getArchetype() {
        if (!this.initialized) {
            this.init();
        }
        return this.archetype;
    }

    @Overwrite
    public void func_75132_a(IContainerListener listener) {
        net.minecraft.inventory.Container container = (net.minecraft.inventory.Container)this;
        if (this.field_75149_d.contains(listener)) {
            listener.func_71110_a(container, this.func_75138_a());
            container.func_75142_b();
        } else {
            this.field_75149_d.add(listener);
            listener.func_71110_a(container, this.func_75138_a());
            container.func_75142_b();
        }
    }

    @Overwrite
    public void func_75142_b() {
        this.detectAndSendChanges(false);
    }

    @Override
    public void detectAndSendChanges(boolean captureOnly) {
        if (!this.initialized) {
            this.init();
        }
        for (int i = 0; i < this.field_75151_b.size(); ++i) {
            net.minecraft.inventory.Slot slot = this.field_75151_b.get(i);
            net.minecraft.item.ItemStack itemstack = slot.func_75211_c();
            net.minecraft.item.ItemStack itemstack1 = (net.minecraft.item.ItemStack)this.field_75153_a.get(i);
            if (net.minecraft.item.ItemStack.func_77989_b((net.minecraft.item.ItemStack)itemstack1, (net.minecraft.item.ItemStack)itemstack)) continue;
            if (this.captureInventory) {
                ItemStackSnapshot originalItem = itemstack1.func_190926_b() ? ItemStackSnapshot.NONE : ((ItemStack)itemstack1).createSnapshot();
                ItemStackSnapshot newItem = itemstack.func_190926_b() ? ItemStackSnapshot.NONE : ((ItemStack)itemstack).createSnapshot();
                SlotAdapter adapter = this.getSlotAdapter(i);
                this.capturedSlotTransactions.add(new SlotTransaction(adapter, originalItem, newItem));
                if (captureOnly) continue;
            }
            itemstack1 = itemstack.func_77946_l();
            this.field_75153_a.set(i, (Object)itemstack1);
            for (IContainerListener listener : this.field_75149_d) {
                listener.func_71111_a((net.minecraft.inventory.Container)this, i, itemstack1);
            }
        }
    }

    @Inject(method={"putStackInSlot"}, at={@At(value="HEAD")})
    public void onPutStackInSlot(int slotId, net.minecraft.item.ItemStack itemstack, CallbackInfo ci) {
        if (this.captureInventory) {
            net.minecraft.inventory.Slot slot;
            if (!this.initialized) {
                this.init();
            }
            if ((slot = this.func_75139_a(slotId)) != null) {
                ItemStackSnapshot originalItem = slot.func_75211_c().func_190926_b() ? ItemStackSnapshot.NONE : ((ItemStack)slot.func_75211_c()).createSnapshot();
                ItemStackSnapshot newItem = itemstack.func_190926_b() ? ItemStackSnapshot.NONE : ((ItemStack)itemstack).createSnapshot();
                SlotAdapter adapter = this.getSlotAdapter(slotId);
                this.capturedSlotTransactions.add(new SlotTransaction(adapter, originalItem, newItem));
            }
        }
    }

    @Override
    public boolean capturingInventory() {
        return this.captureInventory;
    }

    @Override
    public void setCaptureInventory(boolean flag) {
        this.captureInventory = flag;
    }

    @Override
    public void setSpectatorChest(boolean spectatorChest) {
        this.spectatorChest = spectatorChest;
    }

    @Override
    public List<SlotTransaction> getCapturedTransactions() {
        return this.capturedSlotTransactions;
    }

    public SlotProvider<IInventory, net.minecraft.item.ItemStack> inventory$getSlotProvider() {
        if (!this.initialized) {
            this.init();
        }
        return this.slots;
    }

    public Lens<IInventory, net.minecraft.item.ItemStack> inventory$getRootLens() {
        if (!this.initialized) {
            this.init();
        }
        return this.lens;
    }

    public Fabric<IInventory> inventory$getInventory() {
        if (!this.initialized) {
            this.init();
        }
        return this.fabric;
    }

    @Override
    public void setCanInteractWith(@Nullable Predicate<EntityPlayer> predicate) {
        this.canInteractWithPredicate = Optional.ofNullable(predicate);
    }

    @Override
    public Optional<Carrier> getCarrier() {
        return this.carrier;
    }

    @Override
    public SlotAdapter getSlotAdapter(int slot) {
        SlotAdapter adapter = this.adapters.get(slot);
        if (adapter == null) {
            net.minecraft.inventory.Slot mcSlot = this.field_75151_b.get(slot);
            if (mcSlot == null) {
                SpongeImpl.getLogger().warn("Could not find slot #%s in Container %s", (Object)slot, (Object)this.getClass().getName());
                return null;
            }
            return new SlotAdapter(mcSlot);
        }
        return adapter;
    }

    @Override
    public void setPlugin(PluginContainer plugin) {
        this.plugin = plugin;
    }
}

