/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.scoreboard;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketDisplayObjective;
import net.minecraft.network.play.server.SPacketScoreboardObjective;
import net.minecraft.scoreboard.IScoreCriteria;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.ServerScoreboard;
import org.spongepowered.api.scoreboard.Score;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.scoreboard.Team;
import org.spongepowered.api.scoreboard.critieria.Criterion;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlot;
import org.spongepowered.api.scoreboard.objective.Objective;
import org.spongepowered.api.text.Text;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.interfaces.IMixinScore;
import org.spongepowered.common.interfaces.IMixinScoreObjective;
import org.spongepowered.common.interfaces.IMixinServerScoreboard;
import org.spongepowered.common.registry.type.scoreboard.DisplaySlotRegistryModule;
import org.spongepowered.common.scoreboard.SpongeDisplaySlot;
import org.spongepowered.common.scoreboard.SpongeObjective;
import org.spongepowered.common.scoreboard.SpongeScore;
import org.spongepowered.common.text.SpongeTexts;

@Mixin(value={ServerScoreboard.class})
@Implements(value={@Interface(iface=Scoreboard.class, prefix="scoreboard$")})
public abstract class MixinScoreboardLogic
extends net.minecraft.scoreboard.Scoreboard
implements IMixinServerScoreboard {
    @Shadow
    protected abstract void func_96551_b();

    public Optional<Objective> scoreboard$getObjective(String name) {
        if (this.field_96545_a.containsKey(name)) {
            return Optional.of(((IMixinScoreObjective)this.field_96545_a.get(name)).getSpongeObjective());
        }
        return Optional.empty();
    }

    public ScoreObjective func_96535_a(String name, IScoreCriteria criteria) {
        SpongeObjective objective = new SpongeObjective(name, (Criterion)criteria);
        this.scoreboard$addObjective(objective);
        return objective.getObjectiveFor(this);
    }

    public void scoreboard$addObjective(Objective objective) {
        if (this.field_96545_a.containsKey(objective.getName())) {
            throw new IllegalArgumentException("An objective with the name '" + objective.getName() + "' already exists!");
        }
        ScoreObjective scoreObjective = ((SpongeObjective)objective).getObjectiveFor(this);
        ArrayList<ScoreObjective> objectives = (ArrayList<ScoreObjective>)this.field_96543_b.get(objective.getCriterion());
        if (objectives == null) {
            objectives = new ArrayList<ScoreObjective>();
            this.field_96543_b.put((IScoreCriteria)objective.getCriterion(), objectives);
        }
        objectives.add(scoreObjective);
        this.field_96545_a.put(objective.getName(), scoreObjective);
        this.func_96522_a(scoreObjective);
        ((SpongeObjective)objective).updateScores(this);
    }

    @Inject(method={"onScoreObjectiveAdded"}, at={@At(value="RETURN")})
    public void onOnScoreObjectiveAdded(ScoreObjective objective, CallbackInfo ci) {
        this.sendToPlayers((Packet)new SPacketScoreboardObjective(objective, 0));
    }

    public Optional<Objective> scoreboard$getObjective(DisplaySlot slot) {
        ScoreObjective objective = this.field_96541_d[((SpongeDisplaySlot)slot).getIndex()];
        if (objective != null) {
            return Optional.of(((IMixinScoreObjective)objective).getSpongeObjective());
        }
        return Optional.empty();
    }

    @Overwrite
    public void func_96530_a(int slot, ScoreObjective objective) {
        this.scoreboard$updateDisplaySlot(objective == null ? null : ((IMixinScoreObjective)objective).getSpongeObjective(), DisplaySlotRegistryModule.getInstance().getForIndex(slot).get());
    }

    public void scoreboard$updateDisplaySlot(@Nullable Objective objective, DisplaySlot displaySlot) {
        if (objective != null && !objective.getScoreboards().contains(this)) {
            throw new IllegalStateException("Attempting to set an objective's display slot that does not exist on this scoreboard!");
        }
        int index = ((SpongeDisplaySlot)displaySlot).getIndex();
        this.field_96541_d[index] = objective == null ? null : ((SpongeObjective)objective).getObjectiveFor(this);
        this.sendToPlayers((Packet)new SPacketDisplayObjective(index, this.field_96541_d[index]));
    }

    public Set<Objective> scoreboard$getObjectivesByCriteria(Criterion criterion) {
        if (this.field_96543_b.containsKey(criterion)) {
            return ((List)this.field_96543_b.get(criterion)).stream().map(objective -> ((IMixinScoreObjective)objective).getSpongeObjective()).collect(Collectors.toSet());
        }
        return new HashSet<Objective>();
    }

    public Set<Objective> scoreboard$getObjectives() {
        return this.field_96545_a.values().stream().map(objective -> ((IMixinScoreObjective)objective).getSpongeObjective()).collect(Collectors.toSet());
    }

    public void func_96519_k(ScoreObjective objective) {
        this.scoreboard$removeObjective(((IMixinScoreObjective)objective).getSpongeObjective());
    }

    public void scoreboard$removeObjective(Objective objective) {
        ScoreObjective scoreObjective = ((SpongeObjective)objective).getObjectiveFor(this);
        this.field_96545_a.remove(scoreObjective.func_96679_b());
        for (int i = 0; i < 19; ++i) {
            if (this.func_96539_a(i) != scoreObjective) continue;
            this.func_96530_a(i, null);
        }
        this.sendToPlayers((Packet)new SPacketScoreboardObjective(scoreObjective, 1));
        List list = (List)this.field_96543_b.get(scoreObjective.func_96680_c());
        if (list != null) {
            list.remove(scoreObjective);
        }
        for (Map scoreMap : this.field_96544_c.values()) {
            net.minecraft.scoreboard.Score score = (net.minecraft.scoreboard.Score)scoreMap.remove(scoreObjective);
            if (score == null) continue;
            ((IMixinScore)score).getSpongeScore().removeScoreFor(scoreObjective);
        }
        this.func_96551_b();
        ((SpongeObjective)objective).removeObjectiveFor(this);
    }

    public Optional<Team> scoreboard$getTeam(String name) {
        if (this.field_96542_e.containsKey(name)) {
            return Optional.of((Team)this.field_96542_e.get(name));
        }
        return Optional.empty();
    }

    public Set<Team> scoreboard$getTeams() {
        return new HashSet<Team>(this.field_96542_e.values());
    }

    public Optional<Team> scoreboard$getMemberTeam(Text member) {
        return Optional.ofNullable((Team)this.field_96540_f.get(SpongeTexts.toLegacy(member)));
    }

    public void scoreboard$registerTeam(Team spongeTeam) {
        ScorePlayerTeam team = (ScorePlayerTeam)spongeTeam;
        if (this.func_96508_e(spongeTeam.getName()) != null) {
            throw new IllegalArgumentException("A team with the name '" + spongeTeam.getName() + "' already exists!");
        }
        if (team.field_96677_a != null) {
            throw new IllegalArgumentException("The passed in team is already registered to a scoreboard!");
        }
        team.field_96677_a = this;
        this.field_96542_e.put(team.func_96661_b(), team);
        for (String entry : team.func_96670_d()) {
            this.func_151392_a(entry, team.func_96661_b());
        }
        this.func_96523_a(team);
    }

    public void func_96511_d(ScorePlayerTeam team) {
        super.func_96511_d(team);
        team.field_96677_a = null;
    }

    public net.minecraft.scoreboard.Score func_96529_a(String name, ScoreObjective objective) {
        return ((SpongeScore)((IMixinScoreObjective)objective).getSpongeObjective().getOrCreateScore(SpongeTexts.fromLegacy(name))).getScoreFor(objective);
    }

    public void func_178822_d(String name, ScoreObjective objective) {
        if (objective != null) {
            SpongeObjective spongeObjective = ((IMixinScoreObjective)objective).getSpongeObjective();
            Optional<Score> score = spongeObjective.getScore(SpongeTexts.fromLegacy(name));
            if (score.isPresent()) {
                spongeObjective.removeScore(score.get());
            } else {
                SpongeImpl.getLogger().warn("Objective " + objective + " did have have the score " + name);
            }
        } else {
            Text textName = SpongeTexts.fromLegacy(name);
            for (ScoreObjective scoreObjective : this.field_96545_a.values()) {
                ((IMixinScoreObjective)scoreObjective).getSpongeObjective().removeScore(textName);
            }
        }
    }

    public Set<Score> scoreboard$getScores() {
        HashSet<Score> scores = new HashSet<Score>();
        for (ScoreObjective objective : this.field_96545_a.values()) {
            scores.addAll(((IMixinScoreObjective)objective).getSpongeObjective().getScores().values());
        }
        return scores;
    }

    public Set<Score> scoreboard$getScores(Text name) {
        HashSet<Score> scores = new HashSet<Score>();
        for (ScoreObjective objective : this.field_96545_a.values()) {
            ((IMixinScoreObjective)objective).getSpongeObjective().getScore(name).ifPresent(scores::add);
        }
        return scores;
    }

    public void scoreboard$removeScores(Text name) {
        for (ScoreObjective objective : this.field_96545_a.values()) {
            SpongeObjective spongeObjective = ((IMixinScoreObjective)objective).getSpongeObjective();
            spongeObjective.getScore(name).ifPresent(spongeObjective::removeScore);
        }
    }
}

