/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.gen.populators;

import com.flowpowered.math.GenericMath;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.MoreObjects;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenIceSpike;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.PopulatorTypes;
import org.spongepowered.api.world.gen.populator.IceSpike;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldGenIceSpike.class})
public abstract class MixinWorldGenIceSpike
extends WorldGenerator
implements IceSpike {
    private VariableAmount height;
    private VariableAmount increase;
    private VariableAmount count;
    private double prob;

    @Inject(method={"<init>()V"}, at={@At(value="RETURN")})
    public void onConstructed(CallbackInfo ci) {
        this.height = VariableAmount.baseWithRandomAddition(7.0, 4.0);
        this.increase = VariableAmount.baseWithRandomAddition(10.0, 30.0);
        this.prob = 0.0166667;
        this.count = VariableAmount.fixed(2.0);
    }

    @Override
    public PopulatorType getType() {
        return PopulatorTypes.ICE_SPIKE;
    }

    @Override
    public void populate(org.spongepowered.api.world.World worldIn, Extent extent, Random random) {
        Vector3i min = extent.getBlockMin();
        Vector3i size = extent.getBlockSize();
        World world = (World)worldIn;
        BlockPos chunkPos = new BlockPos(min.getX(), min.getY(), min.getZ());
        int n = this.count.getFlooredAmount(random);
        for (int i = 0; i < n; ++i) {
            int x = random.nextInt(size.getX());
            int z = random.nextInt(size.getZ());
            this.func_180709_b(world, random, world.func_175645_m(chunkPos.func_177982_a(x, 0, z)));
        }
    }

    @Overwrite
    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        while (worldIn.func_175623_d(position) && position.func_177956_o() > 2) {
            position = position.func_177977_b();
        }
        if (worldIn.func_180495_p(position).func_177230_c() != Blocks.field_150433_aE) {
            return false;
        }
        position = position.func_177981_b(rand.nextInt(4));
        int height = this.height.getFlooredAmount(rand);
        int width = height / 4 + rand.nextInt(2);
        if (width > 1 && rand.nextDouble() < this.prob) {
            position = position.func_177981_b(this.increase.getFlooredAmount(rand));
        }
        if (width > 1 && rand.nextInt(60) == 0) {
            position = position.func_177981_b(10 + rand.nextInt(30));
        }
        for (int k = 0; k < height; ++k) {
            float f = (1.0f - (float)k / (float)height) * (float)width;
            int l = MathHelper.func_76123_f((float)f);
            for (int i1 = -l; i1 <= l; ++i1) {
                float f1 = (float)MathHelper.func_76130_a((int)i1) - 0.25f;
                for (int j1 = -l; j1 <= l; ++j1) {
                    float f2 = (float)MathHelper.func_76130_a((int)j1) - 0.25f;
                    if ((i1 != 0 || j1 != 0) && !(f1 * f1 + f2 * f2 <= f * f) || (i1 == -l || i1 == l || j1 == -l || j1 == l) && !(rand.nextFloat() <= 0.75f)) continue;
                    IBlockState iblockstate = worldIn.func_180495_p(position.func_177982_a(i1, k, j1));
                    Block block = iblockstate.func_177230_c();
                    if (iblockstate.func_185904_a() == Material.field_151579_a || block == Blocks.field_150346_d || block == Blocks.field_150433_aE || block == Blocks.field_150432_aD) {
                        this.func_175903_a(worldIn, position.func_177982_a(i1, k, j1), Blocks.field_150403_cj.func_176223_P());
                    }
                    if (k == 0 || l <= 1) continue;
                    iblockstate = worldIn.func_180495_p(position.func_177982_a(i1, -k, j1));
                    block = iblockstate.func_177230_c();
                    if (iblockstate.func_185904_a() != Material.field_151579_a && block != Blocks.field_150346_d && block != Blocks.field_150433_aE && block != Blocks.field_150432_aD) continue;
                    this.func_175903_a(worldIn, position.func_177982_a(i1, -k, j1), Blocks.field_150403_cj.func_176223_P());
                }
            }
        }
        int k1 = width - 1;
        if (k1 < 0) {
            k1 = 0;
        } else if (k1 > 1) {
            k1 = 1;
        }
        for (int l1 = -k1; l1 <= k1; ++l1) {
            block5: for (int i2 = -k1; i2 <= k1; ++i2) {
                BlockPos blockpos = position.func_177982_a(l1, -1, i2);
                int j2 = 50;
                if (Math.abs(l1) == 1 && Math.abs(i2) == 1) {
                    j2 = rand.nextInt(5);
                }
                while (blockpos.func_177956_o() > 50) {
                    IBlockState iblockstate1 = worldIn.func_180495_p(blockpos);
                    Block block1 = iblockstate1.func_177230_c();
                    if (iblockstate1.func_185904_a() != Material.field_151579_a && block1 != Blocks.field_150346_d && block1 != Blocks.field_150433_aE && block1 != Blocks.field_150432_aD && block1 != Blocks.field_150403_cj) continue block5;
                    this.func_175903_a(worldIn, blockpos, Blocks.field_150403_cj.func_176223_P());
                    blockpos = blockpos.func_177977_b();
                    if (--j2 > 0) continue;
                    blockpos = blockpos.func_177979_c(rand.nextInt(5) + 1);
                    j2 = rand.nextInt(5);
                }
            }
        }
        return true;
    }

    @Override
    public VariableAmount getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(VariableAmount height) {
        this.height = height;
    }

    @Override
    public double getExtremeSpikeProbability() {
        return this.prob;
    }

    @Override
    public void setExtremeSpikeProbability(double p) {
        this.prob = GenericMath.clamp(p, 0.0, 1.0);
    }

    @Override
    public VariableAmount getExtremeSpikeIncrease() {
        return this.increase;
    }

    @Override
    public void setExtremeSpikeIncrease(VariableAmount increase) {
        this.increase = increase;
    }

    @Override
    public VariableAmount getSpikesPerChunk() {
        return this.count;
    }

    @Override
    public void setSpikesPerChunk(VariableAmount count) {
        this.count = count;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Type", (Object)"IceSpike").add("ExtremeChance", this.prob).add("ExtremeIncrease", (Object)this.increase).add("PerChunk", (Object)this.count).toString();
    }
}

