/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.profile.query;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.profile.GameProfileCache;
import org.spongepowered.common.profile.query.Query;
import org.spongepowered.common.util.SpongeUsernameCache;

public abstract class UniqueIdQuery<T>
extends Query<T> {
    protected UniqueIdQuery(GameProfileCache cache, boolean useCache) {
        super(cache, useCache);
    }

    public static final class MultiGet
    extends UniqueIdQuery<Collection<GameProfile>> {
        private final Iterator<UUID> iterator;

        public MultiGet(GameProfileCache cache, Iterable<UUID> iterable, boolean useCache) {
            super(cache, useCache);
            this.iterator = iterable.iterator();
        }

        @Override
        public Collection<GameProfile> call() throws Exception {
            if (!this.iterator.hasNext()) {
                return ImmutableSet.of();
            }
            return this.fromUniqueIds(Sets.newHashSet(this.iterator));
        }
    }

    public static final class SingleGet
    extends UniqueIdQuery<GameProfile> {
        private final UUID uniqueId;

        public SingleGet(GameProfileCache cache, UUID uniqueId, boolean useCache) {
            super(cache, useCache);
            this.uniqueId = uniqueId;
        }

        @Override
        public GameProfile call() throws Exception {
            String username;
            if (this.useCache && (username = SpongeUsernameCache.getLastKnownUsername(this.uniqueId)) != null) {
                return GameProfile.of(this.uniqueId, username);
            }
            List<GameProfile> gameProfiles = this.fromUniqueIds(Collections.singleton(this.uniqueId));
            return gameProfiles.isEmpty() ? GameProfile.of(this.uniqueId, null) : gameProfiles.get(0);
        }
    }
}

