/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.MapMaker;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.KeyFactory;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.meta.PatternLayer;
import org.spongepowered.api.data.value.mutable.PatternListValue;
import org.spongepowered.api.registry.AdditionalCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.util.TypeTokens;
import org.spongepowered.common.data.SpongeDataManager;

public class KeyRegistryModule
implements AdditionalCatalogRegistryModule<Key<?>> {
    @RegisterCatalog(value=Keys.class)
    private final Map<String, Key<?>> fieldMap = new MapMaker().concurrencyLevel(4).makeMap();
    private final Map<String, Key<?>> keyMap = new MapMaker().concurrencyLevel(4).makeMap();

    public static KeyRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public void registerDefaults() {
        Preconditions.checkState((!SpongeDataManager.areRegistrationsComplete() ? 1 : 0) != 0, (Object)"Attempting to register Keys illegally!");
        this.fieldMap.put("axis", KeyFactory.makeSingleKey(TypeTokens.AXIS_TOKEN, TypeTokens.AXIS_VALUE_TOKEN, DataQuery.of("Axis"), "sponge:axis", "Axis"));
        this.fieldMap.put("color", KeyFactory.makeSingleKey(TypeTokens.COLOR_TOKEN, TypeTokens.COLOR_VALUE_TOKEN, DataQuery.of("Color"), "sponge:color", "Color"));
        this.fieldMap.put("health", KeyFactory.makeSingleKey(TypeTokens.DOUBLE_TOKEN, TypeTokens.BOUNDED_DOUBLE_VALUE_TOKEN, DataQuery.of("Health"), "sponge:health", "Health"));
        this.fieldMap.put("max_health", KeyFactory.makeSingleKey(TypeTokens.DOUBLE_TOKEN, TypeTokens.BOUNDED_DOUBLE_VALUE_TOKEN, DataQuery.of("MaxHealth"), "sponge:max_health", "Max Health"));
        this.fieldMap.put("display_name", KeyFactory.makeSingleKey(TypeTokens.TEXT_TOKEN, TypeTokens.TEXT_VALUE_TOKEN, DataQuery.of("DisplayName"), "sponge:display_name", "Display Name"));
        this.fieldMap.put("career", KeyFactory.makeSingleKey(TypeTokens.CAREER_TOKEN, TypeTokens.CAREER_VALUE_TOKEN, DataQuery.of("Career"), "sponge:career", "Career"));
        this.fieldMap.put("sign_lines", KeyFactory.makeListKey(TypeTokens.LIST_TEXT_TOKEN, TypeTokens.LIST_TEXT_VALUE_TOKEN, DataQuery.of("SignLines"), "sponge:sign_lines", "Sign Lines"));
        this.fieldMap.put("skull_type", KeyFactory.makeSingleKey(TypeTokens.SKULL_TOKEN, TypeTokens.SKULL_VALUE_TOKEN, DataQuery.of("SkullType"), "sponge:skull_type", "Skull Type"));
        this.fieldMap.put("is_sneaking", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("IsSneaking"), "sponge:sneaking", "Is Sneaking"));
        this.fieldMap.put("velocity", KeyFactory.makeSingleKey(TypeTokens.VECTOR_3D_TOKEN, TypeTokens.VECTOR_3D_VALUE_TOKEN, DataQuery.of("Velocity"), "sponge:velocity", "Velocity"));
        this.fieldMap.put("food_level", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.INTEGER_VALUE_TOKEN, DataQuery.of("FoodLevel"), "sponge:food_level", "Food Level"));
        this.fieldMap.put("saturation", KeyFactory.makeSingleKey(TypeTokens.DOUBLE_TOKEN, TypeTokens.DOUBLE_VALUE_TOKEN, DataQuery.of("FoodSaturationLevel"), "sponge:food_saturation_level", "Food Saturation Level"));
        this.fieldMap.put("exhaustion", KeyFactory.makeSingleKey(TypeTokens.DOUBLE_TOKEN, TypeTokens.DOUBLE_VALUE_TOKEN, DataQuery.of("FoodExhaustionLevel"), "sponge:food_exhaustion_level", ""));
        this.fieldMap.put("max_air", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.INTEGER_VALUE_TOKEN, DataQuery.of("MaxAir"), "sponge:max_air", "Max Air"));
        this.fieldMap.put("remaining_air", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.INTEGER_VALUE_TOKEN, DataQuery.of("RemainingAir"), "sponge:remaining_air", "Remaining Air"));
        this.fieldMap.put("fire_ticks", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("FireTicks"), "sponge:fire_ticks", "Fire Ticks"));
        this.fieldMap.put("fire_damage_delay", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("FireDamageDelay"), "sponge:fire_damage_delay", "Fire Damage Delay"));
        this.fieldMap.put("game_mode", KeyFactory.makeSingleKey(TypeTokens.GAME_MODE_TOKEN, TypeTokens.GAME_MODE_VALUE_TOKEN, DataQuery.of("GameMode"), "sponge:game_mode", "Game Mode"));
        this.fieldMap.put("is_screaming", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("IsScreaming"), "sponge:screaming", "Is Screaming"));
        this.fieldMap.put("can_fly", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("CanFly"), "sponge:can_fly", "Can Fly"));
        this.fieldMap.put("can_grief", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("CanGrief"), "sponge:can_grief", "Can Grief"));
        this.fieldMap.put("shrub_type", KeyFactory.makeSingleKey(TypeTokens.SHRUB_TOKEN, TypeTokens.SHRUB_VALUE_TOKEN, DataQuery.of("ShrubType"), "sponge:shrub_type", "Shrub Type"));
        this.fieldMap.put("plant_type", KeyFactory.makeSingleKey(TypeTokens.PLANT_TOKEN, TypeTokens.PLANT_VALUE_TOKEN, DataQuery.of("PlantType"), "sponge:plant_type", "Plant Type"));
        this.fieldMap.put("tree_type", KeyFactory.makeSingleKey(TypeTokens.TREE_TOKEN, TypeTokens.TREE_VALUE_TOKEN, DataQuery.of("TreeType"), "sponge:tree_type", "Tree Type"));
        this.fieldMap.put("log_axis", KeyFactory.makeSingleKey(TypeTokens.LOG_AXIS_TOKEN, TypeTokens.LOG_AXIS_VALUE_TOKEN, DataQuery.of("LogAxis"), "sponge:log_axis", "Log Axis"));
        this.fieldMap.put("invisible", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("Invisible"), "sponge:invisible", "Invisible"));
        this.fieldMap.put("vanish", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("Vanish"), "sponge:vanish", "Vanish"));
        this.fieldMap.put("invisible", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("Invisible"), "sponge:invisible", "Invisible"));
        this.fieldMap.put("powered", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("Powered"), "sponge:powered", "Powered"));
        this.fieldMap.put("layer", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("Layer"), "sponge:layer", "Layer"));
        this.fieldMap.put("represented_item", KeyFactory.makeSingleKey(TypeTokens.ITEM_SNAPSHOT_TOKEN, TypeTokens.ITEM_SNAPSHOT_VALUE_TOKEN, DataQuery.of("ItemStackSnapshot"), "sponge:item_stack_snapshot", "Item Stack Snapshot"));
        this.fieldMap.put("command", KeyFactory.makeSingleKey(TypeTokens.STRING_TOKEN, TypeTokens.STRING_VALUE_TOKEN, DataQuery.of("Command"), "sponge:command", "Command"));
        this.fieldMap.put("success_count", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.INTEGER_VALUE_TOKEN, DataQuery.of("SuccessCount"), "sponge:success_count", "SuccessCount"));
        this.fieldMap.put("tracks_output", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("TracksOutput"), "sponge:tracks_output", "Tracks Output"));
        this.fieldMap.put("last_command_output", KeyFactory.makeOptionalKey(TypeTokens.OPTIONAL_TEXT_TOKEN, TypeTokens.OPTIONAL_TEXT_VALUE_TOKEN, DataQuery.of("LastCommandOutput"), "sponge:last_command_output", "Last Command Output"));
        this.fieldMap.put("trade_offers", KeyFactory.makeListKey(TypeTokens.LIST_TRADE_OFFER_TOKEN, TypeTokens.LIST_VALUE_TRADE_OFFER_TOKEN, DataQuery.of("TradeOffers"), "sponge:trade_offers", "Trade Offers"));
        this.fieldMap.put("dye_color", KeyFactory.makeSingleKey(TypeTokens.DYE_COLOR_TOKEN, TypeTokens.DYE_COLOR_VALUE_TOKEN, DataQuery.of("DyeColor"), "sponge:dye_color", "Dye Color"));
        this.fieldMap.put("firework_flight_modifier", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("FlightModifier"), "sponge:flight_modifier", "Flight Modifier"));
        this.fieldMap.put("firework_effects", KeyFactory.makeListKey(TypeTokens.LIST_FIREWORK_TOKEN, TypeTokens.LIST_VALUE_FIREWORK_TOKEN, DataQuery.of("FireworkEffects"), "sponge:firework_effects", "Firework Effects"));
        this.fieldMap.put("spawner_entities", KeyFactory.makeSingleKey(TypeTokens.WEIGHTED_ENTITY_ARCHETYPE_TABLE_TOKEN, TypeTokens.WEIGHTED_ENTITY_ARCHETYPE_COLLECTION_VALUE_TOKEN, DataQuery.of("SpawnerEntities"), "sponge:spawner_entities", "Spawner Entities"));
        this.fieldMap.put("spawner_maximum_delay", KeyFactory.makeSingleKey(TypeTokens.SHORT_TOKEN, TypeTokens.BOUNDED_SHORT_VALUE_TOKEN, DataQuery.of("SpawnerMaximumDelay"), "sponge:spawner_maximum_delay", "Spawner Maximum Delay"));
        this.fieldMap.put("spawner_maximum_nearby_entities", KeyFactory.makeSingleKey(TypeTokens.SHORT_TOKEN, TypeTokens.BOUNDED_SHORT_VALUE_TOKEN, DataQuery.of("SpawnerMaximumNearbyEntities"), "sponge:spawner_maximum_nearby_entities", "Spawner Maximum Nearby Entities"));
        this.fieldMap.put("spawner_minimum_delay", KeyFactory.makeSingleKey(TypeTokens.SHORT_TOKEN, TypeTokens.BOUNDED_SHORT_VALUE_TOKEN, DataQuery.of("SpawnerMinimumDelay"), "sponge:spawner_minimum_delay", "Spawner Minimum Delay"));
        this.fieldMap.put("spawner_next_entity_to_spawn", KeyFactory.makeSingleKey(TypeTokens.WEIGHTED_ENTITY_ARCHETYPE_TOKEN, TypeTokens.WEIGHTED_ENTITY_ARCHETYPE_VALUE_TOKEN, DataQuery.of("SpawnerNextEntityToSpawn"), "sponge:spawner_next_entity_to_spawn", "Spawner Next Entity To Spawn"));
        this.fieldMap.put("spawner_remaining_delay", KeyFactory.makeSingleKey(TypeTokens.SHORT_TOKEN, TypeTokens.BOUNDED_SHORT_VALUE_TOKEN, DataQuery.of("SpawnerRemainingDelay"), "sponge:spawner_remaining_delay", "Spawner Remaining Delay"));
        this.fieldMap.put("spawner_required_player_range", KeyFactory.makeSingleKey(TypeTokens.SHORT_TOKEN, TypeTokens.BOUNDED_SHORT_VALUE_TOKEN, DataQuery.of("SpawnerRequiredPlayerRange"), "sponge:spawner_required_player_range", "Spawner Required Player Range"));
        this.fieldMap.put("spawner_spawn_count", KeyFactory.makeSingleKey(TypeTokens.SHORT_TOKEN, TypeTokens.BOUNDED_SHORT_VALUE_TOKEN, DataQuery.of("SpawnerSpawnCount"), "sponge:spawner_spawn_count", "Spawner Spawn Count"));
        this.fieldMap.put("spawner_spawn_range", KeyFactory.makeSingleKey(TypeTokens.SHORT_TOKEN, TypeTokens.BOUNDED_SHORT_VALUE_TOKEN, DataQuery.of("SpawnerSpawnRange"), "sponge:spawner_spawn_range", "Spawner Spawn Range"));
        this.fieldMap.put("connected_directions", KeyFactory.makeSetKey(TypeTokens.SET_DIRECTION_TOKEN, TypeTokens.SET_DIRECTION_VALUE_TOKEN, DataQuery.of("ConnectedDirections"), "sponge:connected_directions", "Connected Directions"));
        this.fieldMap.put("connected_north", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("ConnectedNorth"), "sponge:connected_north", "Connected North"));
        this.fieldMap.put("connected_south", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("ConnectedSouth"), "sponge:connected_south", "Connected South"));
        this.fieldMap.put("connected_east", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("ConnectedEast"), "sponge:connected_east", "Connected East"));
        this.fieldMap.put("connected_west", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("ConnectedWest"), "sponge:connected_west", "Connected West"));
        this.fieldMap.put("direction", KeyFactory.makeSingleKey(TypeTokens.DIRECTION_TOKEN, TypeTokens.DIRECTION_VALUE_TOKEN, DataQuery.of("Direction"), "sponge:direction", "Direction"));
        this.fieldMap.put("dirt_type", KeyFactory.makeSingleKey(TypeTokens.DIRT_TOKEN, TypeTokens.DIRT_VALUE_TOKEN, DataQuery.of("DirtType"), "sponge:dirt_type", "Dirt Type"));
        this.fieldMap.put("disguised_block_type", KeyFactory.makeSingleKey(TypeTokens.DISGUISED_BLOCK_TOKEN, TypeTokens.DISGUISED_BLOCK_VALUE_TOKEN, DataQuery.of("DisguisedBlockType"), "sponge:disguised_block_type", "Disguised Block Type"));
        this.fieldMap.put("disarmed", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("Disarmed"), "sponge:disarmed", "Disarmed"));
        this.fieldMap.put("item_enchantments", KeyFactory.makeListKey(TypeTokens.LIST_ITEM_ENCHANTMENT_TOKEN, TypeTokens.LIST_ITEM_ENCHANTMENT_VALUE_TOKEN, DataQuery.of("ItemEnchantments"), "sponge:item_enchantments", "Item Enchantments"));
        this.fieldMap.put("banner_patterns", KeyFactory.makeListKey(TypeTokens.LIST_PATTERN_TOKEN, TypeTokens.LIST_PATTERN_VALUE_TOKEN, DataQuery.of("BannerPatterns"), "sponge:banner_patterns", "Banner Patterns"));
        this.fieldMap.put("banner_base_color", KeyFactory.makeListKey(TypeTokens.LIST_DYE_COLOR_TOKEN, TypeTokens.LIST_DYE_COLOR_VALUE_TOKEN, DataQuery.of("BannerBaseColor"), "sponge:banner_base_color", "Banner Base Color"));
        this.fieldMap.put("horse_color", KeyFactory.makeSingleKey(TypeTokens.HORSE_COLOR_TOKEN, TypeTokens.HORSE_COLOR_VALUE_TOKEN, DataQuery.of("HorseColor"), "sponge:horse_color", "Horse Color"));
        this.fieldMap.put("horse_style", KeyFactory.makeSingleKey(TypeTokens.HORSE_STYLE_TOKEN, TypeTokens.HORSE_STYLE_VALUE_TOKEN, DataQuery.of("HorseStyle"), "sponge:horse_style", "Horse Style"));
        this.fieldMap.put("item_lore", KeyFactory.makeListKey(TypeTokens.LIST_TEXT_TOKEN, TypeTokens.LIST_TEXT_VALUE_TOKEN, DataQuery.of("ItemLore"), "sponge:item_lore", "Item Lore"));
        this.fieldMap.put("book_pages", KeyFactory.makeListKey(TypeTokens.LIST_TEXT_TOKEN, TypeTokens.LIST_TEXT_VALUE_TOKEN, DataQuery.of("BookPages"), "sponge:book_pages", "Book Pages"));
        this.fieldMap.put("golden_apple_type", KeyFactory.makeSingleKey(TypeTokens.GOLDEN_APPLE_TOKEN, TypeTokens.GOLDEN_APPLE_VALUE_TOKEN, DataQuery.of("GoldenAppleType"), "sponge:golden_apple_type", "Golden Apple Type"));
        this.fieldMap.put("is_flying", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("IsFlying"), "sponge:is_flying", "Is Flying"));
        this.fieldMap.put("experience_level", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("ExperienceLevel"), "sponge:experience_level", "Experience Level"));
        this.fieldMap.put("total_experience", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("TotalExperience"), "sponge:total_experience", "Total Experience"));
        this.fieldMap.put("experience_since_level", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("ExperienceSinceLevel"), "sponge:experience_since_level", "Experience Since Level"));
        this.fieldMap.put("experience_from_start_of_level", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("ExperienceFromStartOfLevel"), "sponge:experience_from_start_of_level", "Experience From Start Of Level"));
        this.fieldMap.put("book_author", KeyFactory.makeSingleKey(TypeTokens.TEXT_TOKEN, TypeTokens.TEXT_VALUE_TOKEN, DataQuery.of("BookAuthor"), "sponge:book_author", "Book Author"));
        this.fieldMap.put("breakable_block_types", KeyFactory.makeSetKey(TypeTokens.SET_BLOCK_TOKEN, TypeTokens.SET_BLOCK_VALUE_TOKEN, DataQuery.of("CanDestroy"), "sponge:can_destroy", "Can Destroy"));
        this.fieldMap.put("placeable_blocks", KeyFactory.makeSetKey(TypeTokens.SET_BLOCK_TOKEN, TypeTokens.SET_BLOCK_VALUE_TOKEN, DataQuery.of("CanPlaceOn"), "sponge:can_place_on", "Can Place On"));
        this.fieldMap.put("walking_speed", KeyFactory.makeSingleKey(TypeTokens.DOUBLE_TOKEN, TypeTokens.DOUBLE_VALUE_TOKEN, DataQuery.of("WalkingSpeed"), "sponge:walking_speed", "Walking Speed"));
        this.fieldMap.put("flying_speed", KeyFactory.makeSingleKey(TypeTokens.DOUBLE_TOKEN, TypeTokens.DOUBLE_VALUE_TOKEN, DataQuery.of("FlyingSpeed"), "sponge:flying_speed", "Flying Speed"));
        this.fieldMap.put("slime_size", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("SlimeSize"), "sponge:slime_size", "Slime Size"));
        this.fieldMap.put("villager_zombie_profession", KeyFactory.makeOptionalKey(TypeTokens.OPTIONAL_PROFESSION_TOKEN, TypeTokens.OPTIONAL_PROFESSION_VALUE_TOKEN, DataQuery.of("VillagerZombieProfession"), "sponge:villager_zombie_profession", "Villager Zombie Profession"));
        this.fieldMap.put("is_playing", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("IsPlaying"), "sponge:is_playing", "Is Playing"));
        this.fieldMap.put("is_sitting", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("IsSitting"), "sponge:is_sitting", "Is Sitting"));
        this.fieldMap.put("is_sheared", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("IsSheared"), "sponge:is_sheared", "Is Sheared"));
        this.fieldMap.put("pig_saddle", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("IsPigSaddled"), "sponge:is_pig_saddled", "Is Pig Saddled"));
        this.fieldMap.put("tamed_owner", KeyFactory.makeOptionalKey(TypeTokens.OPTIONAL_UUID_TOKEN, TypeTokens.OPTIONAL_UUID_VALUE_TOKEN, DataQuery.of("TamerUUID"), "sponge:tamer_uuid", "Tamer UUID"));
        this.fieldMap.put("is_wet", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("IsWet"), "sponge:is_wet", "Is Wet"));
        this.fieldMap.put("elder_guardian", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("Elder"), "sponge:elder", "Elder"));
        this.fieldMap.put("coal_type", KeyFactory.makeSingleKey(TypeTokens.COAL_TOKEN, TypeTokens.COAL_VALUE_TOKEN, DataQuery.of("CoalType"), "sponge:coal_type", "Coal Type"));
        this.fieldMap.put("cooked_fish", KeyFactory.makeSingleKey(TypeTokens.COOKED_FISH_TOKEN, TypeTokens.COOKED_FISH_VALUE_TOKEN, DataQuery.of("CookedFishType"), "sponge:cooked_fish_type", "Cooked Fish Type"));
        this.fieldMap.put("fish_type", KeyFactory.makeSingleKey(TypeTokens.FISH_TOKEN, TypeTokens.FISH_VALUE_TOKEN, DataQuery.of("RawFishType"), "sponge:raw_fish_type", "Raw Fish Type"));
        this.fieldMap.put("represented_player", KeyFactory.makeSingleKey(TypeTokens.GAME_PROFILE_TOKEN, TypeTokens.GAME_PROFILE_VALUE_TOKEN, DataQuery.of("RepresentedPlayer"), "sponge:represented_player", "Represented Player"));
        this.fieldMap.put("passed_burn_time", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("PassedBurnTime"), "sponge:passed_burn_time", "Passed Burn Time"));
        this.fieldMap.put("max_burn_time", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("MaxBurnTime"), "sponge:max_burn_time", "Max Burn Time"));
        this.fieldMap.put("passed_cook_time", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("PassedCookTime"), "sponge:passed_cook_time", "Passed Cook Time"));
        this.fieldMap.put("max_cook_time", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("MaxCookTime"), "sponge:max_cook_time", "Max Cook Time"));
        this.fieldMap.put("contained_experience", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.INTEGER_VALUE_TOKEN, DataQuery.of("ContainedExperience"), "sponge:contained_experience", "Contained Experience"));
        this.fieldMap.put("remaining_brew_time", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("RemainingBrewTime"), "sponge:remaining_brew_time", "Remaining Brew Time"));
        this.fieldMap.put("stone_type", KeyFactory.makeSingleKey(TypeTokens.STONE_TOKEN, TypeTokens.STONE_VALUE_TOKEN, DataQuery.of("StoneType"), "sponge:stone_type", "Stone Type"));
        this.fieldMap.put("prismarine_type", KeyFactory.makeSingleKey(TypeTokens.PRISMARINE_TOKEN, TypeTokens.PRISMARINE_VALUE_TOKEN, DataQuery.of("PrismarineType"), "sponge:prismarine_type", "Prismarine Type"));
        this.fieldMap.put("brick_type", KeyFactory.makeSingleKey(TypeTokens.BRICK_TOKEN, TypeTokens.BRICK_VALUE_TOKEN, DataQuery.of("BrickType"), "sponge:brick_type", "Brick Type"));
        this.fieldMap.put("quartz_type", KeyFactory.makeSingleKey(TypeTokens.QUARTZ_TOKEN, TypeTokens.QUARTZ_VALUE_TOKEN, DataQuery.of("QuartzType"), "sponge:quartz_type", "Quartz Type"));
        this.fieldMap.put("sand_type", KeyFactory.makeSingleKey(TypeTokens.SAND_TOKEN, TypeTokens.SAND_VALUE_TOKEN, DataQuery.of("SandType"), "sponge:sand_type", "Sand Type"));
        this.fieldMap.put("sandstone_type", KeyFactory.makeSingleKey(TypeTokens.SAND_STONE_TOKEN, TypeTokens.SAND_STONE_VALUE_TOKEN, DataQuery.of("SandstoneType"), "sponge:sandstone_type", "Sandstone Type"));
        this.fieldMap.put("slab_type", KeyFactory.makeSingleKey(TypeTokens.SLAB_TOKEN, TypeTokens.SLAB_VALUE_TOKEN, DataQuery.of("SlabType"), "sponge:slab_type", "Slab Type"));
        this.fieldMap.put("sandstone_type", KeyFactory.makeSingleKey(TypeTokens.SAND_STONE_TOKEN, TypeTokens.SAND_STONE_VALUE_TOKEN, DataQuery.of("SandstoneType"), "sponge:sandstone_type", "Sandstone Type"));
        this.fieldMap.put("comparator_type", KeyFactory.makeSingleKey(TypeTokens.COMPARATOR_TOKEN, TypeTokens.COMPARATOR_VALUE_TOKEN, DataQuery.of("ComparatorType"), "sponge:comparator_type", "Comparator Type"));
        this.fieldMap.put("hinge_position", KeyFactory.makeSingleKey(TypeTokens.HINGE_TOKEN, TypeTokens.HINGE_VALUE_TOKEN, DataQuery.of("HingePosition"), "sponge:hinge_position", "Hinge Position"));
        this.fieldMap.put("piston_type", KeyFactory.makeSingleKey(TypeTokens.PISTON_TOKEN, TypeTokens.PISTON_VALUE_TOKEN, DataQuery.of("PistonType"), "sponge:piston_type", "Piston Type"));
        this.fieldMap.put("portion_type", KeyFactory.makeSingleKey(TypeTokens.PORTION_TOKEN, TypeTokens.PORTION_VALUE_TOKEN, DataQuery.of("PortionType"), "sponge:portion_type", "Portion Type"));
        this.fieldMap.put("rail_direction", KeyFactory.makeSingleKey(TypeTokens.RAIL_TOKEN, TypeTokens.RAIL_VALUE_TOKEN, DataQuery.of("RailDirection"), "sponge:rail_direction", "Rail Direction"));
        this.fieldMap.put("stair_shape", KeyFactory.makeSingleKey(TypeTokens.STAIR_TOKEN, TypeTokens.STAIR_VALUE_TOKEN, DataQuery.of("StairShape"), "sponge:stair_shape", "Stair Shape"));
        this.fieldMap.put("wall_type", KeyFactory.makeSingleKey(TypeTokens.WALL_TOKEN, TypeTokens.WALL_VALUE_TOKEN, DataQuery.of("WallType"), "sponge:wall_type", "Wall Type"));
        this.fieldMap.put("double_plant_type", KeyFactory.makeSingleKey(TypeTokens.DOUBLE_PLANT_TOKEN, TypeTokens.DOUBLE_PLANT_VALUE_TOKEN, DataQuery.of("DoublePlantType"), "sponge:double_plant_type", "Double Plant Type"));
        this.fieldMap.put("big_mushroom_type", KeyFactory.makeSingleKey(TypeTokens.MUSHROOM_TOKEN, TypeTokens.MUSHROOM_VALUE_TOKEN, DataQuery.of("BigMushroomType"), "sponge:big_mushroom_type", "Big Mushroom Type"));
        this.fieldMap.put("ai_enabled", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("IsAiEnabled"), "sponge:is_ai_enabled", "Is Ai Enabled"));
        this.fieldMap.put("creeper_charged", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("IsCreeperCharged"), "sponge:is_creeper_charged", "Is Creeper Charged"));
        this.fieldMap.put("item_durability", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("ItemDurability"), "sponge:item_durability", "Item Durability"));
        this.fieldMap.put("unbreakable", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("Unbreakable"), "sponge:unbreakable", "Unbreakable"));
        this.fieldMap.put("spawnable_entity_type", KeyFactory.makeSingleKey(TypeTokens.ENTITY_TYPE_TOKEN, TypeTokens.ENTITY_TYPE_VALUE_TOKEN, DataQuery.of("SpawnableEntityType"), "sponge:spawnable_entity_type", "Spawnable Entity Type"));
        this.fieldMap.put("fall_distance", KeyFactory.makeSingleKey(TypeTokens.FLOAT_TOKEN, TypeTokens.FLOAT_VALUE_TOKEN, DataQuery.of("FallDistance"), "sponge:fall_distance", "Fall Distance"));
        this.fieldMap.put("cooldown", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.INTEGER_VALUE_TOKEN, DataQuery.of("Cooldown"), "sponge:cooldown", "Cooldown"));
        this.fieldMap.put("note_pitch", KeyFactory.makeSingleKey(TypeTokens.NOTE_TOKEN, TypeTokens.NOTE_VALUE_TOKEN, DataQuery.of("Note"), "sponge:note", "Note"));
        this.fieldMap.put("vehicle", KeyFactory.makeSingleKey(TypeTokens.ENTITY_TOKEN, TypeTokens.ENTITY_VALUE_TOKEN, DataQuery.of("Vehicle"), "sponge:vehicle", "Vehicle"));
        this.fieldMap.put("base_vehicle", KeyFactory.makeSingleKey(TypeTokens.ENTITY_TOKEN, TypeTokens.ENTITY_VALUE_TOKEN, DataQuery.of("BaseVehicle"), "sponge:base_vehicle", "Base Vehicle"));
        this.fieldMap.put("art", KeyFactory.makeSingleKey(TypeTokens.ART_TOKEN, TypeTokens.ART_VALUE_TOKEN, DataQuery.of("Art"), "sponge:art", "Art"));
        this.fieldMap.put("fall_damage_per_block", KeyFactory.makeSingleKey(TypeTokens.DOUBLE_TOKEN, TypeTokens.DOUBLE_VALUE_TOKEN, DataQuery.of("FallDamagePerBlock"), "sponge:fall_damage_per_block", "Fall Damage Per Block"));
        this.fieldMap.put("max_fall_damage", KeyFactory.makeSingleKey(TypeTokens.DOUBLE_TOKEN, TypeTokens.DOUBLE_VALUE_TOKEN, DataQuery.of("MaxFallDamage"), "sponge:max_fall_damage", "Max Fall Damage"));
        this.fieldMap.put("falling_block_state", KeyFactory.makeSingleKey(TypeTokens.BLOCK_TOKEN, TypeTokens.BLOCK_VALUE_TOKEN, DataQuery.of("FallingBlockState"), "sponge:falling_block_state", "Falling Block State"));
        this.fieldMap.put("can_place_as_block", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("CanPlaceAsBlock"), "sponge:can_place_as_block", "Can Place As Block"));
        this.fieldMap.put("can_drop_as_item", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("CanDropAsItem"), "sponge:can_drop_as_item", "Can Drop As Item"));
        this.fieldMap.put("fall_time", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.INTEGER_VALUE_TOKEN, DataQuery.of("FallTime"), "sponge:fall_time", "Fall Time"));
        this.fieldMap.put("falling_block_can_hurt_entities", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("CanFallingBlockHurtEntities"), "sponge:can_falling_block_hurt_entities", "Can Falling Block Hurt Entities"));
        this.fieldMap.put("represented_block", KeyFactory.makeSingleKey(TypeTokens.BLOCK_TOKEN, TypeTokens.BLOCK_VALUE_TOKEN, DataQuery.of("RepresentedBlock"), "sponge:represented_block", "Represented Block"));
        this.fieldMap.put("offset", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.INTEGER_VALUE_TOKEN, DataQuery.of("BlockOffset"), "sponge:block_offset", "Block Offset"));
        this.fieldMap.put("attached", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("Attached"), "sponge:attached", "Attached"));
        this.fieldMap.put("should_drop", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("ShouldDrop"), "sponge:should_drop", "Should Drop"));
        this.fieldMap.put("extended", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("Extended"), "sponge:extended", "Extended"));
        this.fieldMap.put("growth_stage", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("GrowthStage"), "sponge:growth_stage", "Growth Stage"));
        this.fieldMap.put("open", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("Open"), "sponge:open", "Open"));
        this.fieldMap.put("power", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("Power"), "sponge:power", "Power"));
        this.fieldMap.put("seamless", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("Seamless"), "sponge:seamless", "Seamless"));
        this.fieldMap.put("snowed", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("Snowed"), "sponge:snowed", "Snowed"));
        this.fieldMap.put("suspended", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("Suspended"), "sponge:suspended", "Suspended"));
        this.fieldMap.put("occupied", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("Occupied"), "sponge:occupied", "Occupied"));
        this.fieldMap.put("decayable", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("Decayable"), "sponge:decayable", "Decayable"));
        this.fieldMap.put("in_wall", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("InWall"), "sponge:in_wall", "In Wall"));
        this.fieldMap.put("delay", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("Delay"), "sponge:delay", "Delay"));
        this.fieldMap.put("player_created", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("PlayerCreated"), "sponge:player_created", "Player Created"));
        this.fieldMap.put("item_blockstate", KeyFactory.makeSingleKey(TypeTokens.BLOCK_TOKEN, TypeTokens.BLOCK_VALUE_TOKEN, DataQuery.of("ItemBlockState"), "sponge:item_block_state", "Item Block State"));
        this.fieldMap.put("ocelot_type", KeyFactory.makeSingleKey(TypeTokens.OCELOT_TOKEN, TypeTokens.OCELOT_VALUE_TOKEN, DataQuery.of("OcelotType"), "sponge:ocelot_type", "Ocelot Type"));
        this.fieldMap.put("rabbit_type", KeyFactory.makeSingleKey(TypeTokens.RABBIT_TOKEN, TypeTokens.RABBIT_VALUE_TOKEN, DataQuery.of("RabbitType"), "sponge:rabbit_type", "Rabbit Type"));
        this.fieldMap.put("lock_token", KeyFactory.makeSingleKey(TypeTokens.STRING_TOKEN, TypeTokens.STRING_VALUE_TOKEN, DataQuery.of("Lock"), "sponge:lock", "Lock"));
        this.fieldMap.put("banner_base_color", KeyFactory.makeSingleKey(TypeTokens.DYE_COLOR_TOKEN, TypeTokens.DYE_COLOR_VALUE_TOKEN, DataQuery.of("BannerBaseColor"), "sponge:banner_base_color", "Banner Base Color"));
        this.fieldMap.put("banner_patterns", new PatternKey());
        this.fieldMap.put("respawn_locations", KeyFactory.makeMapKey(TypeTokens.MAP_UUID_VECTOR3D_TOKEN, TypeTokens.MAP_UUID_VECTOR3D_VALUE_TOKEN, DataQuery.of("RespawnLocations"), "sponge:respawn_locations", "Respawn Locations"));
        this.fieldMap.put("expiration_ticks", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("ExpirationTicks"), "sponge:expiration_ticks", "Expiration Ticks"));
        this.fieldMap.put("skin_unique_id", KeyFactory.makeSingleKey(TypeTokens.UUID_TOKEN, TypeTokens.UUID_VALUE_TOKEN, DataQuery.of("SkinUUID"), "sponge:skin_uuid", "Skin UUID"));
        this.fieldMap.put("moisture", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("Moisture"), "sponge:moisture", "Moisture"));
        this.fieldMap.put("angry", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("Angry"), "sponge:angry", "Angry"));
        this.fieldMap.put("anger", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("Anger"), "sponge:anger", "Anger"));
        this.fieldMap.put("rotation", KeyFactory.makeSingleKey(TypeTokens.ROTATION_TOKEN, TypeTokens.ROTATION_VALUE_TOKEN, DataQuery.of("Rotation"), "sponge:rotation", "Rotation"));
        this.fieldMap.put("is_splash_potion", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("IsSplashPotion"), "sponge:is_splash_potion", "Is Splash Potion"));
        this.fieldMap.put("affects_spawning", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("AffectsSpawning"), "sponge:affects_spawning", "Affects Spawning"));
        this.fieldMap.put("critical_hit", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("CriticalHit"), "sponge:critical_hit", "Critical Hit"));
        this.fieldMap.put("generation", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("Generation"), "sponge:generation", "Generation"));
        this.fieldMap.put("passengers", KeyFactory.makeSingleKey(TypeTokens.ENTITY_TOKEN, TypeTokens.ENTITY_VALUE_TOKEN, DataQuery.of("PassengerSnapshot"), "sponge:passenger_snapshot", "Passenger Snapshot"));
        this.fieldMap.put("knockback_strength", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("KnockbackStrength"), "sponge:knockback_strength", "Knockback Strength"));
        this.fieldMap.put("persists", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("Persists"), "sponge:persists", "Persists"));
        this.fieldMap.put("stored_enchantments", KeyFactory.makeListKey(TypeTokens.LIST_ITEM_ENCHANTMENT_TOKEN, TypeTokens.LIST_ITEM_ENCHANTMENT_VALUE_TOKEN, DataQuery.of("StoredEnchantments"), "sponge:stored_enchantments", "Stored Enchantments"));
        this.fieldMap.put("is_sprinting", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("Sprinting"), "sponge:sprinting", "Sprinting"));
        this.fieldMap.put("stuck_arrows", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("StuckArrows"), "sponge:stuck_arrows", "Stuck Arrows"));
        this.fieldMap.put("vanish_ignores_collision", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("VanishIgnoresCollision"), "sponge:vanish_ignores_collision", "Vanish Ignores Collision"));
        this.fieldMap.put("vanish_prevents_targeting", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("VanishPreventsTargeting"), "sponge:vanish_prevents_targeting", "Vanish Prevents Targeting"));
        this.fieldMap.put("is_aflame", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("IsAflame"), "sponge:is_aflame", "Is Aflame"));
        this.fieldMap.put("can_breed", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("CanBreed"), "sponge:can_breed", "Can Breed"));
        this.fieldMap.put("fluid_item_stack", KeyFactory.makeSingleKey(TypeTokens.FLUID_TOKEN, TypeTokens.FLUID_VALUE_TOKEN, DataQuery.of("FluidItemContainerSnapshot"), "sponge:fluid_item_container_snapshot", "Fluid Item Container Snapshot"));
        this.fieldMap.put("fluid_tank_contents", KeyFactory.makeMapKey(TypeTokens.MAP_DIRECTION_FLUID_TOKEN, TypeTokens.MAP_DIRECTION_FLUID_VALUE_TOKEN, DataQuery.of("FluidTankContents"), "sponge:fluid_tank_contents", "Fluid Tank Contents"));
        this.fieldMap.put("custom_name_visible", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("CustomNameVisible"), "sponge:custom_name_visible", "Custom Name Visible"));
        this.fieldMap.put("first_date_played", KeyFactory.makeSingleKey(TypeTokens.INSTANT_TOKEN, TypeTokens.INSTANT_VALUE_TOKEN, DataQuery.of("FirstTimeJoined"), "sponge:first_time_joined", "First Time Joined"));
        this.fieldMap.put("last_date_played", KeyFactory.makeSingleKey(TypeTokens.INSTANT_TOKEN, TypeTokens.INSTANT_VALUE_TOKEN, DataQuery.of("LastTimePlayed"), "sponge:last_time_played", "Last Time Played"));
        this.fieldMap.put("hide_enchantments", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("HideEnchantments"), "sponge:hide_enchantments", "Hide Enchantments"));
        this.fieldMap.put("hide_attributes", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("HideAttributes"), "sponge:hide_attributes", "Hide Attributes"));
        this.fieldMap.put("hide_unbreakable", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("HideUnbreakable"), "sponge:hide_unbreakable", "Hide Unbreakable"));
        this.fieldMap.put("hide_can_destroy", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("HideCanDestroy"), "sponge:hide_can_destroy", "Hide Can Destroy"));
        this.fieldMap.put("hide_can_place", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("HideCanPlace"), "sponge:hide_can_place", "Hide Can Place"));
        this.fieldMap.put("hide_miscellaneous", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("HideMiscellaneous"), "sponge:hide_miscellaneous", "Hide Miscellaneous"));
        this.fieldMap.put("potion_effects", KeyFactory.makeListKey(TypeTokens.LIST_POTION_TOKEN, TypeTokens.LIST_POTION_VALUE_TOKEN, DataQuery.of("PotionEffects"), "sponge:potion_effects", "Potion Effects"));
        this.fieldMap.put("body_rotations", KeyFactory.makeMapKey(TypeTokens.MAP_BODY_VECTOR3D_TOKEN, TypeTokens.MAP_BODY_VECTOR3D_VALUE_TOKEN, DataQuery.of("BodyRotations"), "sponge:body_rotations", "Body Rotations"));
        this.fieldMap.put("head_rotation", KeyFactory.makeSingleKey(TypeTokens.VECTOR_3D_TOKEN, TypeTokens.VECTOR_3D_VALUE_TOKEN, DataQuery.of("HeadRotation"), "sponge:head_rotation", "Head Rotation"));
        this.fieldMap.put("chest_rotation", KeyFactory.makeSingleKey(TypeTokens.VECTOR_3D_TOKEN, TypeTokens.VECTOR_3D_VALUE_TOKEN, DataQuery.of("ChestRotation"), "sponge:chest_rotation", "Chest Rotation"));
        this.fieldMap.put("left_arm_rotation", KeyFactory.makeSingleKey(TypeTokens.VECTOR_3D_TOKEN, TypeTokens.VECTOR_3D_VALUE_TOKEN, DataQuery.of("LeftArmRotation"), "sponge:left_arm_rotation", "Left Arm Rotation"));
        this.fieldMap.put("right_arm_rotation", KeyFactory.makeSingleKey(TypeTokens.VECTOR_3D_TOKEN, TypeTokens.VECTOR_3D_VALUE_TOKEN, DataQuery.of("RightArmRotation"), "sponge:right_arm_rotation", "Right Arm Rotation"));
        this.fieldMap.put("left_leg_rotation", KeyFactory.makeSingleKey(TypeTokens.VECTOR_3D_TOKEN, TypeTokens.VECTOR_3D_VALUE_TOKEN, DataQuery.of("LeftLegRotation"), "sponge:left_leg_rotation", "Left Leg Rotation"));
        this.fieldMap.put("right_leg_rotation", KeyFactory.makeSingleKey(TypeTokens.VECTOR_3D_TOKEN, TypeTokens.VECTOR_3D_VALUE_TOKEN, DataQuery.of("RightLegRotation"), "sponge:right_leg_rotation", "Right Leg Rotation"));
        this.fieldMap.put("beacon_primary_effect", KeyFactory.makeOptionalKey(TypeTokens.OPTIONAL_POTION_TOKEN, TypeTokens.OPTIONAL_POTION_VALUE_TOKEN, DataQuery.of("BeaconPrimaryEffect"), "sponge:beacon_primary_effect", "Beacon Primary Effect"));
        this.fieldMap.put("beacon_secondary_effect", KeyFactory.makeOptionalKey(TypeTokens.OPTIONAL_POTION_TOKEN, TypeTokens.OPTIONAL_POTION_VALUE_TOKEN, DataQuery.of("BeaconSecondaryEffect"), "sponge:beacon_secondary_effect", "Beacon Secondary Effect"));
        this.fieldMap.put("targeted_location", KeyFactory.makeSingleKey(TypeTokens.VECTOR_3D_TOKEN, TypeTokens.VECTOR_3D_VALUE_TOKEN, DataQuery.of("TargetedVector3d"), "sponge:targeted_vector_3d", "Targeted Vector3d"));
        this.fieldMap.put("fuse_duration", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.INTEGER_VALUE_TOKEN, DataQuery.of("FuseDuration"), "sponge:fuse_duration", "Fuse Duration"));
        this.fieldMap.put("ticks_remaining", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.INTEGER_VALUE_TOKEN, DataQuery.of("TicksRemaining"), "sponge:ticks_remaining", "Ticks Remaining"));
        this.fieldMap.put("explosion_radius", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.INTEGER_VALUE_TOKEN, DataQuery.of("ExplosionRadius"), "sponge:explosion_radius", "Explosion Radius"));
        this.fieldMap.put("armor_stand_has_arms", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("HasArms"), "sponge:has_arms", "Has Arms"));
        this.fieldMap.put("armor_stand_has_base_plate", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("HasBasePlate"), "sponge:has_base_plate", "Has Base Plate"));
        this.fieldMap.put("armor_stand_marker", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("IsMarker"), "sponge:is_marker", "Is Marker"));
        this.fieldMap.put("armor_stand_is_small", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("IsSmall"), "sponge:is_small", "Is Small"));
        this.fieldMap.put("is_silent", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("IsSilent"), "sponge:is_silent", "Is Silent"));
        this.fieldMap.put("glowing", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("Glowing"), "sponge:glowing", "Glowing"));
        this.fieldMap.put("pickup_rule", KeyFactory.makeSingleKey(TypeTokens.PICKUP_TOKEN, TypeTokens.PICKUP_VALUE_TOKEN, DataQuery.of("PickupRule"), "sponge:pickup_rule", "Pickup Rule"));
        this.fieldMap.put("invulnerability_ticks", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("HurtTime"), "sponge:invulnerability_ticks", "Invulnerability Ticks"));
        this.fieldMap.put("has_gravity", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("HasGravity"), "sponge:has_gravity", "Has Gravity"));
        this.fieldMap.put("statistics", KeyFactory.makeSingleKey(TypeTokens.STATISTIC_MAP_TOKEN, TypeTokens.STATISTIC_MAP_VALUE_TOKEN, DataQuery.of("Statistics"), "sponge:statistics", "Statistics"));
        this.fieldMap.put("infinite_despawn_delay", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("InfiniteDespawnDelay"), "sponge:infinite_despawn_delay", "Infinite Despawn Delay"));
        this.fieldMap.put("infinite_pickup_delay", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("InfinitePickupDelay"), "sponge:infinite_pickup_delay", "Infinite Pickup Delay"));
        this.fieldMap.put("despawn_delay", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("DespawnDelay"), "sponge:despawn_delay", "Despawn Delay"));
        this.fieldMap.put("pickup_delay", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("PickupDelay"), "sponge:pickup_delay", "Pickup Delay"));
        this.fieldMap.put("end_gateway_age", KeyFactory.makeSingleKey(TypeTokens.LONG_TOKEN, TypeTokens.LONG_VALUE_TOKEN, DataQuery.of("EndGatewayAge"), "sponge:end_gateway_age", "End Gateway Age"));
        this.fieldMap.put("end_gateway_teleport_cooldown", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.INTEGER_VALUE_TOKEN, DataQuery.of("EndGatewayTeleportCooldown"), "sponge:end_gateway_teleport_cooldown", "End Gateway Teleport Cooldown"));
        this.fieldMap.put("exit_position", KeyFactory.makeSingleKey(TypeTokens.VECTOR_3I_TOKEN, TypeTokens.VECTOR_3I_VALUE_TOKEN, DataQuery.of("ExitPosition"), "sponge:exit_position", "Exit Position"));
        this.fieldMap.put("exact_teleport", KeyFactory.makeSingleKey(TypeTokens.VECTOR_3I_TOKEN, TypeTokens.VECTOR_3I_VALUE_TOKEN, DataQuery.of("ExactTeleport"), "sponge:exact_teleport", "Exact Teleport"));
        this.fieldMap.put("structure_author", KeyFactory.makeSingleKey(TypeTokens.STRING_TOKEN, TypeTokens.STRING_VALUE_TOKEN, DataQuery.of("StructureAuthor"), "sponge:structure_author", "Structure Author"));
        this.fieldMap.put("structure_ignore_entities", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("StructureIgnoreEntities"), "sponge:structure_ignore_entities", "Structure Ignore Entities"));
        this.fieldMap.put("structure_integrity", KeyFactory.makeSingleKey(TypeTokens.FLOAT_TOKEN, TypeTokens.FLOAT_VALUE_TOKEN, DataQuery.of("StructureIntegrity"), "sponge:structure_integrity", "Structure Integrity"));
        this.fieldMap.put("structure_mode", KeyFactory.makeSingleKey(TypeTokens.STRUCTURE_MODE_TOKEN, TypeTokens.STRUCTURE_MODE_VALUE_TOKEN, DataQuery.of("StructureMode"), "sponge:structure_mode", "Structure Mode"));
        this.fieldMap.put("structure_position", KeyFactory.makeSingleKey(TypeTokens.STRING_TOKEN, TypeTokens.STRING_VALUE_TOKEN, DataQuery.of("StructurePosition"), "sponge:structure_position", "Structure Position"));
        this.fieldMap.put("structure_powered", KeyFactory.makeSingleKey(TypeTokens.STRING_TOKEN, TypeTokens.STRING_VALUE_TOKEN, DataQuery.of("StructurePowered"), "sponge:structure_powered", "Structure Powered"));
        this.fieldMap.put("structure_seed", KeyFactory.makeSingleKey(TypeTokens.LONG_TOKEN, TypeTokens.LONG_VALUE_TOKEN, DataQuery.of("StructureSeed"), "sponge:structure_seed", "Structure Seed"));
        this.fieldMap.put("structure_show_air", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("StructureShowAir"), "sponge:structure_show_air", "Structure Show Air"));
        this.fieldMap.put("structure_show_bounding_box", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("StructureShowBoundingBox"), "sponge:structure_show_bounding_box", "Structure Show Bounding Box"));
        this.fieldMap.put("structure_size", KeyFactory.makeSingleKey(TypeTokens.VECTOR_3I_TOKEN, TypeTokens.VECTOR_3I_VALUE_TOKEN, DataQuery.of("StructureSize"), "sponge:structure_size", "Structure Size"));
        this.fieldMap.put("absorption", KeyFactory.makeSingleKey(TypeTokens.DOUBLE_TOKEN, TypeTokens.DOUBLE_VALUE_TOKEN, DataQuery.of("Absorption"), "sponge:absorption", "Absorption"));
        this.fieldMap.put("area_effect_cloud_radius", KeyFactory.makeSingleKey(TypeTokens.DOUBLE_TOKEN, TypeTokens.BOUNDED_DOUBLE_VALUE_TOKEN, DataQuery.of("CloudRadius"), "sponge:area_effect_cloud_radius", "AreaEffectCloud Radius"));
        this.fieldMap.put("area_effect_cloud_radius_on_use", KeyFactory.makeSingleKey(TypeTokens.DOUBLE_TOKEN, TypeTokens.BOUNDED_DOUBLE_VALUE_TOKEN, DataQuery.of("CloudRadiusOnUse"), "sponge:area_effect_cloud_radius_on_use", "AreaEffectCloud Radius On Use"));
        this.fieldMap.put("area_effect_cloud_radius_per_tick", KeyFactory.makeSingleKey(TypeTokens.DOUBLE_TOKEN, TypeTokens.BOUNDED_DOUBLE_VALUE_TOKEN, DataQuery.of("CloudRadiusPerTick"), "sponge:area_effect_cloud_radius_per_tick", "AreaEffectCloud Radius Per Tick"));
        this.fieldMap.put("area_effect_cloud_color", KeyFactory.makeSingleKey(TypeTokens.COLOR_TOKEN, TypeTokens.COLOR_VALUE_TOKEN, DataQuery.of("CloudColor"), "sponge:area_effect_cloud_color", "AreaEffectCloud Color"));
        this.fieldMap.put("area_effect_cloud_duration", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("CloudDuration"), "sponge:area_effect_cloud_duration", "AreaEffectCloud Duration"));
        this.fieldMap.put("area_effect_cloud_duration_on_use", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("CloudDurationOnUse"), "sponge:area_effect_cloud_duration_on_use", "AreaEffectCloud Duration On Use"));
        this.fieldMap.put("area_effect_cloud_wait_time", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("CloudWaitTime"), "sponge:area_effect_cloud_wait_time", "AreaEffectCloud Wait Time"));
        this.fieldMap.put("area_effect_cloud_reapplication_delay", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("CloudReapplicationDelay"), "sponge:area_effect_cloud_wait_time", "AreaEffectCloud Wait Time"));
        this.fieldMap.put("area_effect_cloud_age", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("CloudAge"), "sponge:area_effect_cloud_age", "AreaEffectCloud Age"));
        this.fieldMap.put("area_effect_cloud_particle_type", KeyFactory.makeSingleKey(TypeTokens.PARTICLE_TYPE_TOKEN, TypeTokens.PARTICLE_TYPE_VALUE_TOKEN, DataQuery.of("CloudParticleType"), "sponge:area_effect_cloud_particle_type", "AreaEffectCloud ParticleType"));
        this.fieldMap.put("age", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("EntityAge"), "sponge:entity_age", "Entity Age"));
        this.fieldMap.put("attack_damage", KeyFactory.makeSingleKey(TypeTokens.DOUBLE_TOKEN, TypeTokens.BOUNDED_DOUBLE_VALUE_TOKEN, DataQuery.of("EntityAttackDamage"), "sponge:entity_attack_damage", "Entity Attack Damage"));
        this.fieldMap.put("base_size", KeyFactory.makeSingleKey(TypeTokens.DOUBLE_TOKEN, TypeTokens.BOUNDED_DOUBLE_VALUE_TOKEN, DataQuery.of("EntityBaseSize"), "sponge:base_size", "Entity Base Size"));
        this.fieldMap.put("damage_entity_map", KeyFactory.makeMapKey(TypeTokens.ENTITY_TYPE_DOUBLE_MAP_TOKEN, TypeTokens.ENTITY_TYPE_DOUBLE_MAP_VALUE_TOKEN, DataQuery.of("DamageEntityTypeMap"), "sponge:entity_type_damage_map", "Entity Type Damage Map"));
        this.fieldMap.put("dominant_hand", KeyFactory.makeSingleKey(TypeTokens.HAND_PREFERENCE_TYPE_TOKEN, TypeTokens.HAND_PREFERENCE_VALUE_TOKEN, DataQuery.of("HandPreference"), "sponge:hand_preference", "Hand Preference"));
        this.fieldMap.put("filled", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("Filled"), "sponge:filled", "Filled"));
        this.fieldMap.put("fluid_level", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("LiquidLevel"), "sponge:fluid_level", "Fluid Level"));
        this.fieldMap.put("health_scale", KeyFactory.makeSingleKey(TypeTokens.DOUBLE_TOKEN, TypeTokens.BOUNDED_DOUBLE_VALUE_TOKEN, DataQuery.of("HealthScale"), "sponge:health_scale", "Health Scale"));
        this.fieldMap.put("height", KeyFactory.makeSingleKey(TypeTokens.DOUBLE_TOKEN, TypeTokens.BOUNDED_DOUBLE_VALUE_TOKEN, DataQuery.of("EntityHeight"), "sponge:entity_height", "Entity Height"));
        this.fieldMap.put("held_experience", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("HeldExperience"), "sponge:held_experience", "Held Experience"));
        this.fieldMap.put("is_sleeping", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("IsSleeping"), "sponge:is_sleeping", "Is Sleeping"));
        this.fieldMap.put("johnny_vindicator", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("JohnnyVindicator"), "sponge:johnny_vindicator", "Johnny Vindicator"));
        this.fieldMap.put("last_attacker", KeyFactory.makeSingleKey(TypeTokens.LAST_ATTACKER_TOKEN, TypeTokens.LAST_ATTACKER_VALUE_TOKEN, DataQuery.of("LastAttacker"), "sponge:last_attacker", "Last Attacking Entity"));
        this.fieldMap.put("llama_strength", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("LlamaStrength"), "sponge:llama_strength", "Llama Strength"));
        this.fieldMap.put("llama_variant", KeyFactory.makeSingleKey(TypeTokens.LLAMA_VARIANT_TOKEN, TypeTokens.LLAMA_VARIANT_VALUE_TOKEN, DataQuery.of("LlamaVariant"), "sponge:llama_variant", "Llama Variant"));
        this.fieldMap.put("scale", KeyFactory.makeSingleKey(TypeTokens.DOUBLE_TOKEN, TypeTokens.DOUBLE_VALUE_TOKEN, DataQuery.of("EntityScale"), "sponge:entity_scale", "Entity Scale"));
        this.fieldMap.put("will_shatter", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("WillShatter"), "sponge:will_shatter", "Will Shatter"));
        this.fieldMap.put("wire_attachments", KeyFactory.makeMapKey(TypeTokens.WIRE_ATTACHMENT_MAP_TOKEN, TypeTokens.WIRE_ATTACHMENT_MAP_VALUE_TOKEN, DataQuery.of("WireAttachmentMap"), "sponge:wire_attachment_map", "Wire Attachment Map"));
        this.fieldMap.put("wire_attachment_east", KeyFactory.makeSingleKey(TypeTokens.WIRE_ATTACHMENT_TYPE_TOKEN, TypeTokens.WIRE_ATTACHMENT_TYPE_VALUE_TOKEN, DataQuery.of("WireAttachmentEast"), "sponge:wire_attachment_east", "Wire Attachment East"));
        this.fieldMap.put("wire_attachment_south", KeyFactory.makeSingleKey(TypeTokens.WIRE_ATTACHMENT_TYPE_TOKEN, TypeTokens.WIRE_ATTACHMENT_TYPE_VALUE_TOKEN, DataQuery.of("WireAttachmentSouth"), "sponge:wire_attachment_south", "Wire Attachment South"));
        this.fieldMap.put("wire_attachment_north", KeyFactory.makeSingleKey(TypeTokens.WIRE_ATTACHMENT_TYPE_TOKEN, TypeTokens.WIRE_ATTACHMENT_TYPE_VALUE_TOKEN, DataQuery.of("WireAttachmentNorth"), "sponge:wire_attachment_north", "Wire Attachment North"));
        this.fieldMap.put("wire_attachment_west", KeyFactory.makeSingleKey(TypeTokens.WIRE_ATTACHMENT_TYPE_TOKEN, TypeTokens.WIRE_ATTACHMENT_TYPE_VALUE_TOKEN, DataQuery.of("WireAttachmentWest"), "sponge:wire_attachment_west", "Wire Attachment West"));
        this.fieldMap.put("age", KeyFactory.makeSingleKey(TypeTokens.INTEGER_TOKEN, TypeTokens.BOUNDED_INTEGER_VALUE_TOKEN, DataQuery.of("Age"), "sponge:age", "Age"));
        this.fieldMap.put("is_adult", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("IsAdult"), "sponge:is_adult", "Is Adult"));
        this.fieldMap.put("is_baby", KeyFactory.makeSingleKey(TypeTokens.BOOLEAN_TOKEN, TypeTokens.BOOLEAN_VALUE_TOKEN, DataQuery.of("IsBaby"), "sponge:is_baby", "Is Baby"));
        this.fieldMap.put("health_scale", KeyFactory.makeSingleKey(TypeTokens.DOUBLE_TOKEN, TypeTokens.BOUNDED_DOUBLE_VALUE_TOKEN, DataQuery.of("HealthScale"), "sponge:health_scale", "Health Scale"));
        for (Key<?> key : this.fieldMap.values()) {
            this.keyMap.put(key.getId().toLowerCase(Locale.ENGLISH), key);
        }
    }

    @Override
    public void registerAdditionalCatalog(Key<?> extraCatalog) {
        Preconditions.checkState((!SpongeDataManager.areRegistrationsComplete() ? 1 : 0) != 0, (Object)"Cannot register new Keys after Data Registration has completed!");
        Preconditions.checkNotNull(extraCatalog, (Object)"Key cannot be null!");
        String id = extraCatalog.getId().toLowerCase(Locale.ENGLISH);
        Preconditions.checkArgument((!id.startsWith("sponge:") ? 1 : 0) != 0, (Object)("A plugin is trying to register custom keys under the sponge id namespace! This is a fake key! " + id));
        this.keyMap.put(id, extraCatalog);
    }

    @Override
    public Optional<Key<?>> getById(String id) {
        return Optional.ofNullable(this.keyMap.get(id));
    }

    @Override
    public Collection<Key<?>> getAll() {
        return Collections.unmodifiableCollection(this.keyMap.values());
    }

    KeyRegistryModule() {
    }

    static final class Holder {
        static final KeyRegistryModule INSTANCE = new KeyRegistryModule();

        Holder() {
        }
    }

    private static final class PatternKey
    implements Key<PatternListValue> {
        static final TypeToken<PatternListValue> VALUE_TOKEN = new TypeToken<PatternListValue>(){
            private static final long serialVersionUID = -1L;
        };
        static final TypeToken<List<PatternLayer>> ELEMENT_TOKEN = new TypeToken<List<PatternLayer>>(){
            private static final long serialVersionUID = -1L;
        };
        private static final DataQuery BANNER_PATTERNS = DataQuery.of("BannerPatterns");

        PatternKey() {
        }

        @Override
        public TypeToken<PatternListValue> getValueToken() {
            return VALUE_TOKEN;
        }

        @Override
        public TypeToken<?> getElementToken() {
            return ELEMENT_TOKEN;
        }

        @Override
        public DataQuery getQuery() {
            return BANNER_PATTERNS;
        }

        @Override
        public String getId() {
            return "sponge:banner_patterns";
        }

        @Override
        public String getName() {
            return "BannerPatterns";
        }
    }
}

