/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.statistic;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.statistic.StatisticType;
import org.spongepowered.api.statistic.StatisticTypes;
import org.spongepowered.common.statistic.SpongeStatisticType;

public final class StatisticTypeRegistryModule
implements CatalogRegistryModule<StatisticType> {
    @RegisterCatalog(value=StatisticTypes.class)
    private final Map<String, StatisticType> statisticTypeMappings = Maps.newHashMap();

    @Override
    public Optional<StatisticType> getById(String id) {
        return Optional.ofNullable(this.statisticTypeMappings.get(id.toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<StatisticType> getAll() {
        return ImmutableList.copyOf(this.statisticTypeMappings.values());
    }

    @Override
    public void registerDefaults() {
        this.registerDefault("basic");
        this.registerDefault("blocks_broken");
        this.registerDefault("entities_killed");
        this.registerDefault("items_broken");
        this.registerDefault("items_crafted");
        this.registerDefault("items_dropped");
        this.registerDefault("items_picked_up");
        this.registerDefault("items_used");
        this.registerDefault("killed_by_entity");
    }

    private void registerDefault(String id) {
        this.statisticTypeMappings.put(id, new SpongeStatisticType(id));
    }
}

