/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scheduler;

import org.spongepowered.common.event.tracking.CauseTracker;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.phase.plugin.PluginPhase;
import org.spongepowered.common.scheduler.ScheduledTask;
import org.spongepowered.common.scheduler.SchedulerBase;

public class SyncScheduler
extends SchedulerBase {
    private volatile long counter = 0L;

    SyncScheduler() {
        super(ScheduledTask.TaskSynchronicity.SYNCHRONOUS);
    }

    void tick() {
        ++this.counter;
        this.runTick();
    }

    @Override
    protected long getTimestamp(ScheduledTask task) {
        if (task.getState() == ScheduledTask.ScheduledTaskState.WAITING) {
            if (task.delayIsTicks) {
                return this.counter;
            }
            return super.getTimestamp(task);
        }
        if (task.getState().isActive) {
            if (task.intervalIsTicks) {
                return this.counter;
            }
            return super.getTimestamp(task);
        }
        return 0L;
    }

    @Override
    protected void executeTaskRunnable(ScheduledTask task, Runnable runnable) {
        CauseTracker.getInstance().switchToPhase(PluginPhase.State.SCHEDULED_TASK, PhaseContext.start().source(task).addCaptures().complete());
        runnable.run();
        CauseTracker.getInstance().completePhase(PluginPhase.State.SCHEDULED_TASK);
    }
}

