/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.pagination;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.common.service.pagination.PaginationCalculator;
import org.spongepowered.common.util.SpongeCommonTranslationHelper;

abstract class ActivePagination {
    private static final Text SLASH_TEXT = Text.of("/");
    private static final Text DIVIDER_TEXT = Text.of(" ");
    private static final Text CONTINUATION_TEXT = SpongeCommonTranslationHelper.t("...", new Object[0]);
    private final Supplier<Optional<MessageReceiver>> src;
    private final UUID id = UUID.randomUUID();
    private final Text nextPageText;
    private final Text prevPageText;
    @Nullable
    private final Text title;
    @Nullable
    private final Text header;
    @Nullable
    private final Text footer;
    private int currentPage;
    private final int maxContentLinesPerPage;
    protected final PaginationCalculator calc;
    private final Text padding;

    public ActivePagination(Supplier<Optional<MessageReceiver>> src, PaginationCalculator calc, @Nullable Text title, @Nullable Text header, @Nullable Text footer, Text padding) {
        this.src = src;
        this.calc = calc;
        this.title = title;
        this.header = header;
        this.footer = footer;
        this.padding = padding;
        this.nextPageText = SpongeCommonTranslationHelper.t("\u00bb", new Object[0]).toBuilder().color(TextColors.BLUE).style(TextStyles.UNDERLINE).onClick(TextActions.runCommand("/pagination " + this.id.toString() + " next")).onHover(TextActions.showText(Text.of("/page next"))).onShiftClick(TextActions.insertText("/page next")).build();
        this.prevPageText = SpongeCommonTranslationHelper.t("\u00ab", new Object[0]).toBuilder().color(TextColors.BLUE).style(TextStyles.UNDERLINE).onClick(TextActions.runCommand("/pagination " + this.id.toString() + " prev")).onHover(TextActions.showText(Text.of("/page prev"))).onShiftClick(TextActions.insertText("/page prev")).build();
        int maxContentLinesPerPage = calc.getLinesPerPage(src.get().get()) - 1;
        if (title != null) {
            maxContentLinesPerPage -= calc.getLines(title);
        }
        if (header != null) {
            maxContentLinesPerPage -= calc.getLines(header);
        }
        if (footer != null) {
            maxContentLinesPerPage -= calc.getLines(footer);
        }
        this.maxContentLinesPerPage = maxContentLinesPerPage;
    }

    public UUID getId() {
        return this.id;
    }

    protected abstract Iterable<Text> getLines(int var1) throws CommandException;

    protected abstract boolean hasPrevious(int var1);

    protected abstract boolean hasNext(int var1);

    protected abstract int getTotalPages();

    public void nextPage() throws CommandException {
        this.specificPage(this.currentPage + 1);
    }

    public void previousPage() throws CommandException {
        this.specificPage(this.currentPage - 1);
    }

    public void currentPage() throws CommandException {
        this.specificPage(this.currentPage);
    }

    protected int getCurrentPage() {
        return this.currentPage;
    }

    protected int getMaxContentLinesPerPage() {
        return this.maxContentLinesPerPage;
    }

    public void specificPage(int page) throws CommandException {
        MessageReceiver src = this.src.get().orElseThrow(() -> new CommandException(SpongeCommonTranslationHelper.t("Source for pagination %s is no longer active!", this.getId())));
        this.currentPage = page;
        ArrayList<Text> toSend = new ArrayList<Text>();
        Text title = this.title;
        if (title != null) {
            toSend.add(title);
        }
        if (this.header != null) {
            toSend.add(this.header);
        }
        for (Text line : this.getLines(page)) {
            toSend.add(line);
        }
        Text footer = this.calculateFooter(page);
        toSend.add(this.calc.center(footer, this.padding));
        if (this.footer != null) {
            toSend.add(this.footer);
        }
        src.sendMessages(toSend);
    }

    protected Text calculateFooter(int currentPage) {
        boolean hasPrevious = this.hasPrevious(currentPage);
        boolean hasNext = this.hasNext(currentPage);
        Text.Builder ret = Text.builder();
        if (hasPrevious) {
            ret.append(this.prevPageText).append(DIVIDER_TEXT);
        } else {
            ret.append(Text.of("\u00ab")).append(DIVIDER_TEXT);
        }
        boolean needsDiv = false;
        int totalPages = this.getTotalPages();
        if (totalPages > 1) {
            ret.append(Text.of(TextActions.showText(Text.of("/page " + currentPage)), TextActions.runCommand("/pagination " + this.id + ' ' + currentPage), TextActions.insertText("/page " + currentPage), currentPage)).append(SLASH_TEXT).append(Text.of(TextActions.showText(Text.of("/page " + totalPages)), TextActions.runCommand("/pagination " + this.id + ' ' + totalPages), TextActions.insertText("/page " + totalPages), totalPages));
            needsDiv = true;
        }
        if (hasNext) {
            if (needsDiv) {
                ret.append(DIVIDER_TEXT);
            }
            ret.append(this.nextPageText);
        } else {
            if (needsDiv) {
                ret.append(DIVIDER_TEXT);
            }
            ret.append(Text.of("\u00bb"));
        }
        ret.color(this.padding.getColor());
        if (this.title != null) {
            ret.style(this.title.getStyle());
        }
        return ret.build();
    }

    protected void padPage(List<Text> currentPage, int currentPageLines, boolean addContinuation) {
        int maxContentLinesPerPage = this.getMaxContentLinesPerPage();
        for (int i = currentPageLines; i < maxContentLinesPerPage; ++i) {
            if (addContinuation && i == maxContentLinesPerPage - 1) {
                currentPage.add(CONTINUATION_TEXT);
                continue;
            }
            currentPage.add(0, Text.EMPTY);
        }
    }
}

