/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.schematic;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.world.extent.ArchetypeVolume;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.schematic.BlockPalette;
import org.spongepowered.api.world.schematic.BlockPaletteType;
import org.spongepowered.api.world.schematic.BlockPaletteTypes;
import org.spongepowered.api.world.schematic.Schematic;
import org.spongepowered.common.util.gen.ArrayMutableBlockBuffer;
import org.spongepowered.common.world.schematic.SpongeArchetypeVolume;
import org.spongepowered.common.world.schematic.SpongeSchematic;

public class SpongeSchematicBuilder
implements Schematic.Builder {
    private ArchetypeVolume volume;
    private Extent view;
    private BlockPalette palette;
    private BlockPaletteType type = BlockPaletteTypes.LOCAL;
    private DataView metadata;
    private Map<String, Object> metaValues = Maps.newHashMap();

    @Override
    public Schematic.Builder volume(ArchetypeVolume volume) {
        this.volume = volume;
        return this;
    }

    @Override
    public Schematic.Builder volume(Extent volume) {
        this.view = volume;
        return this;
    }

    @Override
    public Schematic.Builder palette(BlockPalette palette) {
        this.palette = palette;
        this.type = palette.getType();
        return this;
    }

    @Override
    public Schematic.Builder paletteType(BlockPaletteType type) {
        this.type = type;
        this.palette = null;
        return this;
    }

    @Override
    public Schematic.Builder metadata(DataView metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    public Schematic.Builder metaValue(String key, Object value) {
        this.metaValues.put(key, value);
        return this;
    }

    @Override
    public Schematic.Builder from(Schematic value) {
        this.volume = value;
        this.view = null;
        this.palette = value.getPalette();
        this.type = this.palette.getType();
        this.metadata = value.getMetadata();
        this.metaValues.clear();
        return this;
    }

    @Override
    public Schematic.Builder reset() {
        this.volume = null;
        this.view = null;
        this.palette = null;
        this.type = BlockPaletteTypes.LOCAL;
        this.metadata = null;
        this.metaValues.clear();
        return this;
    }

    @Override
    public Schematic build() throws IllegalArgumentException {
        Vector3i size;
        Vector3i min;
        if (this.palette == null) {
            this.palette = this.type.create();
        }
        Preconditions.checkArgument((this.volume != null || this.view != null ? 1 : 0) != 0);
        if (this.volume != null) {
            min = this.volume.getBlockMin();
            size = this.volume.getBlockSize();
        } else {
            min = this.view.getBlockMin();
            size = this.view.getBlockSize();
        }
        if (this.metadata == null) {
            this.metadata = DataContainer.createNew();
        }
        for (Map.Entry<String, Object> entry : this.metaValues.entrySet()) {
            this.metadata.set(DataQuery.of(".", entry.getKey()), entry.getValue());
        }
        if (this.volume == null) {
            ArrayMutableBlockBuffer volume = new ArrayMutableBlockBuffer(this.palette, min, size);
            HashMap tiles = Maps.newHashMap();
            this.view.getBlockWorker().iterate((v, x, y, z) -> {
                volume.setBlock(x, y, z, v.getBlock(x, y, z));
                Optional<TileEntity> tile = v.getTileEntity(x, y, z);
                if (tile.isPresent()) {
                    tiles.put(new Vector3i(x, y, z), tile.get().createArchetype());
                }
            });
            return new SpongeSchematic(volume, tiles, this.metadata);
        }
        return new SpongeSchematic((SpongeArchetypeVolume)this.volume, this.metadata);
    }
}

