/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.launch.plugin;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.launchwrapper.Launch;

public final class PluginSource {
    public static final PluginSource CLASSPATH = new PluginSource();
    private final Optional<Path> source;
    private boolean onClasspath;

    private PluginSource() {
        this.source = Optional.empty();
        this.onClasspath = true;
    }

    PluginSource(Path path) {
        this.source = Optional.of(path);
    }

    public Optional<Path> getPath() {
        return this.source;
    }

    public void addToClasspath() {
        if (this.onClasspath) {
            return;
        }
        this.onClasspath = true;
        try {
            Launch.classLoader.addURL(this.source.get().toUri().toURL());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to add plugin " + this + " to classpath", e);
        }
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginSource other = (PluginSource)o;
        return this.source.equals(other.source);
    }

    public int hashCode() {
        return this.source.hashCode();
    }

    public String toString() {
        if (this.source.isPresent()) {
            return this.source.get().toString();
        }
        return "unknown";
    }

    public static Optional<Path> find(Class<?> type) {
        CodeSource source = type.getProtectionDomain().getCodeSource();
        if (source == null) {
            return Optional.empty();
        }
        URL location = source.getLocation();
        String path = location.getPath();
        if (location.getProtocol().equals("jar")) {
            int pos;
            if (path.startsWith("file:") && (pos = path.lastIndexOf(33)) >= 0) {
                path = path.substring(0, pos);
            }
        } else if (!location.getProtocol().equals("file")) {
            return Optional.empty();
        }
        if (path.endsWith(".jar")) {
            try {
                return Optional.of(Paths.get(new URI(path)));
            }
            catch (URISyntaxException e) {
                throw new InvalidPathException(path, "Not a valid URI");
            }
        }
        return Optional.empty();
    }
}

