/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.mixin.core.entity.player;

import com.flowpowered.math.vector.Vector3d;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockBed;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.action.SleepingEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.interfaces.entity.player.IMixinEntityPlayer;
import org.spongepowered.common.mixin.core.entity.MixinEntityLivingBase;
import org.spongepowered.common.util.VecHelper;

@Mixin(value={EntityPlayer.class})
public abstract class MixinEntityPlayer
extends MixinEntityLivingBase
implements IMixinEntityPlayer {
    @Shadow
    public InventoryPlayer field_71071_by;
    @Shadow
    protected boolean field_71083_bS;
    @Shadow
    @Nullable
    public BlockPos field_71081_bT;
    @Shadow
    private int field_71076_b;
    @Shadow
    @Nullable
    private BlockPos field_71077_c;
    @Shadow
    private boolean field_82248_d;
    protected Int2ObjectOpenHashMap<BlockPos> spawnChunkMap = new Int2ObjectOpenHashMap();
    protected IntSet spawnForcedSet = new IntOpenHashSet();

    @Shadow
    public abstract void func_180473_a(BlockPos var1, boolean var2);

    @Overwrite
    @Nullable
    public BlockPos func_180470_cg() {
        return this.getBedLocation(this.field_71093_bK);
    }

    @Override
    public BlockPos getBedLocation(int dimension) {
        return dimension == 0 ? this.field_71077_c : (BlockPos)this.spawnChunkMap.get(dimension);
    }

    @Overwrite
    public boolean func_82245_bX() {
        return this.isSpawnForced(this.field_71093_bK);
    }

    @Override
    public boolean isSpawnForced(int dimension) {
        return dimension == 0 ? this.field_82248_d : this.spawnForcedSet.contains(dimension);
    }

    @Inject(method={"setSpawnPoint"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetSpawnPoint(BlockPos pos, boolean forced, CallbackInfo ci) {
        if (this.field_71093_bK != 0) {
            this.setSpawnChunk(pos, forced, this.field_71093_bK);
            ci.cancel();
        }
    }

    public void setSpawnChunk(@Nullable BlockPos pos, boolean forced, int dimension) {
        if (dimension == 0) {
            if (pos != null) {
                this.field_71077_c = pos;
                this.field_82248_d = forced;
            } else {
                this.field_71077_c = null;
                this.field_82248_d = false;
            }
        } else if (pos != null) {
            this.spawnChunkMap.put(dimension, (Object)pos);
            if (forced) {
                this.spawnForcedSet.add(dimension);
            } else {
                this.spawnForcedSet.remove(dimension);
            }
        } else {
            this.spawnChunkMap.remove(dimension);
            this.spawnForcedSet.remove(dimension);
        }
    }

    @Inject(method={"readEntityFromNBT"}, at={@At(value="RETURN")})
    private void onReadEntityFromNBT(NBTTagCompound tagCompound, CallbackInfo ci) {
        NBTTagList spawnList = tagCompound.func_150295_c("Spawns", 10);
        for (int i = 0; i < spawnList.func_74745_c(); ++i) {
            NBTTagCompound spawnData = spawnList.func_150305_b(i);
            int spawnDim = spawnData.func_74762_e("Dim");
            this.spawnChunkMap.put(spawnDim, (Object)new BlockPos(spawnData.func_74762_e("SpawnX"), spawnData.func_74762_e("SpawnY"), spawnData.func_74762_e("SpawnZ")));
            if (!spawnData.func_74767_n("SpawnForced")) continue;
            this.spawnForcedSet.add(spawnDim);
        }
    }

    @Inject(method={"writeEntityToNBT"}, at={@At(value="RETURN")})
    private void onWriteEntityToNBT(NBTTagCompound tagCompound, CallbackInfo ci) {
        NBTTagList spawnList = new NBTTagList();
        ObjectIterator itr = this.spawnChunkMap.int2ObjectEntrySet().fastIterator();
        while (itr.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)itr.next();
            int dim = entry.getIntKey();
            BlockPos spawn = (BlockPos)entry.getValue();
            NBTTagCompound spawnData = new NBTTagCompound();
            spawnData.func_74768_a("Dim", dim);
            spawnData.func_74768_a("SpawnX", spawn.func_177958_n());
            spawnData.func_74768_a("SpawnY", spawn.func_177956_o());
            spawnData.func_74768_a("SpawnZ", spawn.func_177952_p());
            spawnData.func_74757_a("SpawnForced", this.spawnForcedSet.contains(dim));
            spawnList.func_74742_a((NBTBase)spawnData);
        }
        tagCompound.func_74782_a("Spawns", (NBTBase)spawnList);
    }

    @Inject(method={"trySleep"}, at={@At(value="HEAD")}, cancellable=true)
    private void onTrySleep(BlockPos bedPos, CallbackInfoReturnable<EntityPlayer.SleepResult> ci) {
        Sponge.getCauseStackManager().pushCause(this);
        SleepingEvent.Pre event = SpongeEventFactory.createSleepingEventPre(Sponge.getCauseStackManager().getCurrentCause(), ((org.spongepowered.api.world.World)this.field_70170_p).createSnapshot(bedPos.func_177958_n(), bedPos.func_177956_o(), bedPos.func_177952_p()), this);
        if (SpongeImpl.postEvent(event)) {
            ci.setReturnValue(EntityPlayer.SleepResult.OTHER_PROBLEM);
        }
        Sponge.getCauseStackManager().popCause();
    }

    @Overwrite
    public void func_70999_a(boolean immediately, boolean updateWorldFlag, boolean setSpawn) {
        Transform<org.spongepowered.api.world.World> newLocation = null;
        IBlockState iblockstate = this.field_70170_p.func_180495_p(this.field_71081_bT);
        if (this.field_71081_bT != null && iblockstate.func_177230_c() == Blocks.field_150324_C) {
            BlockPos blockpos = BlockBed.func_176468_a((World)this.field_70170_p, (BlockPos)this.field_71081_bT, (int)0);
            if (blockpos == null) {
                blockpos = this.field_71081_bT.func_177984_a();
            }
            newLocation = this.getTransform().setPosition(new Vector3d((float)blockpos.func_177958_n() + 0.5f, (float)blockpos.func_177956_o() + 0.1f, (float)blockpos.func_177952_p() + 0.5f));
        }
        BlockSnapshot bed = this.getWorld().createSnapshot(VecHelper.toVector3i(this.field_71081_bT));
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().pushCause(this);
            SleepingEvent.Post event = SpongeEventFactory.createSleepingEventPost(Sponge.getCauseStackManager().getCurrentCause(), bed, Optional.ofNullable(newLocation), this, setSpawn);
            if (SpongeImpl.postEvent(event)) {
                return;
            }
            this.func_70105_a(0.6f, 1.8f);
            if (newLocation != null) {
                event.getSpawnTransform().ifPresent(this::setLocationAndAngles);
                this.field_71083_bS = false;
                if (!this.field_70170_p.field_72995_K && updateWorldFlag) {
                    this.field_70170_p.func_72854_c();
                }
                int n = this.field_71076_b = immediately ? 0 : 100;
                if (setSpawn) {
                    this.func_180473_a(this.field_71081_bT, false);
                }
                SpongeImpl.postEvent(SpongeEventFactory.createSleepingEventFinish(Sponge.getCauseStackManager().getCurrentCause(), bed, this));
            }
        }
    }
}

