/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.mixin.core.network;

import com.google.common.base.Splitter;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketChatMessage;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.message.MessageChannelEvent;
import org.spongepowered.api.event.message.MessageEvent;
import org.spongepowered.api.network.RemoteConnection;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.chat.ChatTypes;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.text.SpongeTexts;
import org.spongepowered.server.chat.ChatFormatter;
import org.spongepowered.server.interfaces.IMixinNetHandlerPlayServer;
import org.spongepowered.server.network.VanillaChannelRegistrar;

@Mixin(value={NetHandlerPlayServer.class})
public abstract class MixinNetHandlerPlayServer
implements RemoteConnection,
IMixinNetHandlerPlayServer {
    private static final String CHECK_THREAD_AND_ENQUEUE = "Lnet/minecraft/network/PacketThreadUtil;checkThreadAndEnqueue(Lnet/minecraft/network/Packet;Lnet/minecraft/network/INetHandler;Lnet/minecraft/util/IThreadListener;)V";
    @Shadow
    @Final
    private MinecraftServer field_147367_d;
    @Shadow
    public EntityPlayerMP field_147369_b;
    private static final Splitter CHANNEL_SPLITTER = Splitter.on((char)'\u0000');
    private final Set<String> registeredChannels = new HashSet<String>();

    @Shadow
    public abstract void func_147359_a(Packet<?> var1);

    @Override
    public boolean supportsChannel(String name) {
        return this.registeredChannels.contains(name);
    }

    @Inject(method={"<init>*"}, at={@At(value="RETURN")})
    private void registerChannels(CallbackInfo ci) {
        ((VanillaChannelRegistrar)Sponge.getChannelRegistrar()).registerChannels((NetHandlerPlayServer)this);
    }

    @Inject(method={"processChatMessage"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendMessage(Lnet/minecraft/util/text/ITextComponent;Z)V")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private void onProcessChatMessage(CPacketChatMessage packet, CallbackInfo ci, String s, ITextComponent component) {
        ChatFormatter.formatChatComponent((TextComponentTranslation)component);
        Text[] message = SpongeTexts.splitChatMessage((TextComponentTranslation)component);
        MessageChannel originalChannel = ((Player)this.field_147369_b).getMessageChannel();
        Sponge.getCauseStackManager().pushCause(this.field_147369_b);
        MessageChannelEvent.Chat event = SpongeEventFactory.createMessageChannelEventChat(Sponge.getCauseStackManager().getCurrentCause(), originalChannel, Optional.of(originalChannel), new MessageEvent.MessageFormatter(message[0], message[1]), Text.of(s), false);
        if (!SpongeImpl.postEvent(event) && !event.isMessageCancelled()) {
            event.getChannel().ifPresent(channel -> channel.send(this.field_147369_b, event.getMessage(), ChatTypes.CHAT));
        } else {
            ci.cancel();
        }
        Sponge.getCauseStackManager().popCause();
    }

    @Redirect(method={"processChatMessage"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendMessage(Lnet/minecraft/util/text/ITextComponent;Z)V"))
    private void cancelSendChatMsgImpl(PlayerList manager, ITextComponent component, boolean chat) {
    }

    @Inject(method={"processCustomPayload"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/PacketThreadUtil;checkThreadAndEnqueue(Lnet/minecraft/network/Packet;Lnet/minecraft/network/INetHandler;Lnet/minecraft/util/IThreadListener;)V", shift=At.Shift.AFTER)}, cancellable=true)
    private void onProcessPluginMessage(CPacketCustomPayload packet, CallbackInfo ci) {
        String name = packet.func_149559_c();
        if (name.startsWith("MC|")) {
            return;
        }
        ci.cancel();
        switch (name) {
            case "REGISTER": {
                String channels = packet.func_180760_b().toString(StandardCharsets.UTF_8);
                for (String channel : CHANNEL_SPLITTER.split((CharSequence)channels)) {
                    if (!this.registeredChannels.add(channel)) continue;
                    Sponge.getCauseStackManager().pushCause(this);
                    Sponge.getCauseStackManager().pushCause(this.field_147369_b);
                    SpongeImpl.postEvent(SpongeEventFactory.createChannelRegistrationEventRegister(Sponge.getCauseStackManager().getCurrentCause(), channel));
                    Sponge.getCauseStackManager().popCauses(2);
                }
                break;
            }
            case "UNREGISTER": {
                String channels = packet.func_180760_b().toString(StandardCharsets.UTF_8);
                for (String channel : CHANNEL_SPLITTER.split((CharSequence)channels)) {
                    if (!this.registeredChannels.remove(channel)) continue;
                    Sponge.getCauseStackManager().pushCause(this);
                    Sponge.getCauseStackManager().pushCause(this.field_147369_b);
                    SpongeImpl.postEvent(SpongeEventFactory.createChannelRegistrationEventUnregister(Sponge.getCauseStackManager().getCurrentCause(), channel));
                    Sponge.getCauseStackManager().popCauses(2);
                }
                break;
            }
            default: {
                ((VanillaChannelRegistrar)Sponge.getChannelRegistrar()).post(this, packet);
            }
        }
    }
}

