/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api;

import net.kyori.adventure.key.Key;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.util.ResettableBuilder;
import org.spongepowered.plugin.PluginContainer;

public interface ResourceKey
extends Key {
    public static final String MINECRAFT_NAMESPACE = "minecraft";
    public static final String SPONGE_NAMESPACE = "sponge";

    public static ResourceKey minecraft(String value) {
        return ResourceKey.of(MINECRAFT_NAMESPACE, value);
    }

    public static ResourceKey sponge(String value) {
        return ResourceKey.of(SPONGE_NAMESPACE, value);
    }

    public static Builder builder() {
        return Sponge.getRegistry().getBuilderRegistry().provideBuilder(Builder.class);
    }

    public static ResourceKey of(String namespace, String value) {
        return Sponge.getRegistry().getBuilderRegistry().provideBuilder(Builder.class).namespace(namespace).value(value).build();
    }

    public static ResourceKey of(PluginContainer container, String value) {
        return Sponge.getRegistry().getBuilderRegistry().provideBuilder(Builder.class).namespace(container).value(value).build();
    }

    public static ResourceKey resolve(String value) {
        return Sponge.getRegistry().getBuilderRegistry().provideBuilder(Builder.class).value(value).build();
    }

    default public String getNamespace() {
        return this.namespace();
    }

    default public String getValue() {
        return this.value();
    }

    default public String getFormatted() {
        return this.asString();
    }

    default public String asString() {
        return this.namespace() + ':' + this.value();
    }

    default public int compareTo(Key o) {
        return super.compareTo(o);
    }

    public static interface Builder
    extends ResettableBuilder<ResourceKey, Builder> {
        public Builder namespace(String var1);

        public Builder namespace(PluginContainer var1);

        public Builder value(String var1);

        public ResourceKey build() throws IllegalStateException;
    }
}

