/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.command;

import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResults;
import org.spongepowered.api.util.ResettableBuilder;

public interface CommandResult {
    public static Builder builder() {
        return Sponge.getRegistry().getBuilderRegistry().provideBuilder(Builder.class);
    }

    public static CommandResult success() {
        return CommandResults.SUCCESS;
    }

    public static CommandResult empty() {
        return CommandResults.EMPTY;
    }

    public static CommandResult error(Component errorMessage) {
        return CommandResult.builder().error(errorMessage).build();
    }

    public boolean isSuccess();

    public int getResult();

    public Optional<Component> getErrorMessage();

    public static interface Builder
    extends ResettableBuilder<CommandResult, Builder> {
        public Builder setResult(int var1);

        public Builder error(@Nullable Component var1);

        public CommandResult build();
    }
}

