/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data;

import io.leangen.geantyref.TypeToken;
import java.util.Collection;
import java.util.Optional;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataProvider;
import org.spongepowered.api.data.DuplicateDataStoreException;
import org.spongepowered.api.data.DuplicateProviderException;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.UnregisteredKeyException;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.data.persistence.DataStore;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.util.CatalogBuilder;
import org.spongepowered.plugin.PluginContainer;

public interface DataRegistration
extends CatalogType {
    public static Builder builder() {
        return Sponge.getRegistry().getBuilderRegistry().provideBuilder(Builder.class);
    }

    public <V extends Value<E>, E> Collection<DataProvider<V, E>> getProvidersFor(Key<V> var1) throws UnregisteredKeyException;

    public Optional<DataStore> getDataStore(TypeToken<? extends DataHolder> var1);

    public Optional<DataStore> getDataStore(Class<? extends DataHolder> var1);

    public Iterable<Key<?>> getKeys();

    public PluginContainer getPluginContainer();

    @SafeVarargs
    public static <T, V extends Value<T>> DataRegistration of(Key<V> key, Class<? extends DataHolder> dataHolder, Class<? extends DataHolder> ... dataHolders) {
        DataStore dataStore = DataStore.of(key, DataQuery.of(key.getKey().getNamespace(), key.getKey().getValue()), dataHolder, dataHolders);
        return ((Builder)DataRegistration.builder().dataKey(key).store(dataStore).key(key.getKey())).build();
    }

    public static interface Builder
    extends CatalogBuilder<DataRegistration, Builder> {
        public Builder store(DataStore var1) throws DuplicateDataStoreException;

        public Builder provider(DataProvider<?, ?> var1) throws DuplicateProviderException;

        public Builder dataKey(Key<?> var1);

        public Builder dataKey(Key<?> var1, Key<?> ... var2);

        public Builder dataKey(Iterable<Key<?>> var1);

        @Override
        public Builder reset();

        @Override
        public DataRegistration build();
    }
}

