/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data.persistence;

import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataManipulator;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.util.ResettableBuilder;

public interface DataStore {
    public Collection<Type> getSupportedTypes();

    public DataView serialize(DataManipulator var1, DataView var2);

    default public DataView serialize(Iterable<Value<?>> values, DataView view) {
        return this.serialize(DataManipulator.immutableOf(values), view);
    }

    default public DataView serialize(Iterable<Value<?>> values) {
        return this.serialize(DataManipulator.immutableOf(values));
    }

    default public DataView serialize(DataManipulator dataManipulator) {
        DataContainer dataView = DataContainer.createNew();
        this.serialize(dataManipulator, (DataView)dataView);
        return dataView;
    }

    public void deserialize(DataManipulator.Mutable var1, DataView var2);

    default public DataManipulator.Mutable deserialize(DataView view) {
        DataManipulator.Mutable dataManipulator = DataManipulator.mutableOf();
        this.deserialize(dataManipulator, view);
        return dataManipulator;
    }

    @SafeVarargs
    public static <T, V extends Value<T>> DataStore of(Key<V> key, DataQuery dataQuery, TypeToken<? extends DataHolder> typeToken, TypeToken<? extends DataHolder> ... typeTokens) {
        return DataStore.builder().pluginData(key.getKey()).holder(typeToken).holder(typeTokens).key(key, dataQuery).build();
    }

    @SafeVarargs
    public static <T, V extends Value<T>> DataStore of(Key<V> key, DataQuery dataQuery, Class<? extends DataHolder> type, Class<? extends DataHolder> ... types) {
        return DataStore.builder().pluginData(key.getKey()).holder(type).holder(types).key(key, dataQuery).build();
    }

    public static Builder builder() {
        return Sponge.getRegistry().getBuilderRegistry().provideBuilder(Builder.class);
    }

    public static interface Builder
    extends ResettableBuilder<DataStore, Builder> {
        public HolderStep pluginData(ResourceKey var1);

        public HolderStep vanillaData();

        public static interface EndStep
        extends SerializersStep,
        ResettableBuilder<DataStore, Builder> {
            public DataStore build();
        }

        public static interface SerializersStep
        extends HolderStep,
        ResettableBuilder<DataStore, Builder> {
            default public <T, V extends Value<T>> EndStep key(Key<V> key, String ... dataQueries) {
                return this.key(key, DataQuery.of(dataQueries));
            }

            public <T, V extends Value<T>> EndStep key(Key<V> var1, DataQuery var2);

            public <T, V extends Value<T>> EndStep key(Key<V> var1, BiConsumer<DataView, T> var2, Function<DataView, Optional<T>> var3);
        }

        public static interface HolderStep
        extends ResettableBuilder<DataStore, Builder> {
            public SerializersStep holder(TypeToken<? extends DataHolder> ... var1);

            public SerializersStep holder(Class<? extends DataHolder> ... var1);
        }
    }
}

