/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data.value;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.Value;

public interface ValueContainer {
    public <E> Optional<E> get(Key<? extends Value<E>> var1);

    default public <E> Optional<E> get(Supplier<? extends Key<? extends Value<E>>> key) {
        return this.get(key.get());
    }

    default public OptionalInt getInt(Key<? extends Value<Integer>> key) {
        return this.get(key).map(OptionalInt::of).orElseGet(OptionalInt::empty);
    }

    default public OptionalInt getInt(Supplier<? extends Key<? extends Value<Integer>>> key) {
        return this.get(key).map(OptionalInt::of).orElseGet(OptionalInt::empty);
    }

    default public OptionalDouble getDouble(Key<? extends Value<Double>> key) {
        return this.get(key).map(OptionalDouble::of).orElseGet(OptionalDouble::empty);
    }

    default public OptionalDouble getDouble(Supplier<? extends Key<? extends Value<Double>>> key) {
        return this.get(key).map(OptionalDouble::of).orElseGet(OptionalDouble::empty);
    }

    default public OptionalLong getLong(Key<? extends Value<Long>> key) {
        return this.get(key).map(OptionalLong::of).orElseGet(OptionalLong::empty);
    }

    default public OptionalLong getLong(Supplier<? extends Key<? extends Value<Long>>> key) {
        return this.get(key).map(OptionalLong::of).orElseGet(OptionalLong::empty);
    }

    default public <E> E require(Key<? extends Value<E>> key) {
        return this.get(key).orElseThrow(() -> new NoSuchElementException(String.format("Could not retrieve value for key '%s'", key.toString())));
    }

    default public <E> E require(Supplier<? extends Key<? extends Value<E>>> key) {
        return this.require(key.get());
    }

    default public <E> @Nullable E getOrNull(Key<? extends Value<E>> key) {
        Optional<E> value = this.get(key);
        if (value.isPresent()) {
            return value.get();
        }
        if (!this.supports(key)) {
            throw new UnsupportedOperationException("Key not supported. Key: " + key);
        }
        return null;
    }

    default public <E> @Nullable E getOrNull(Supplier<? extends Key<? extends Value<E>>> key) {
        return this.getOrNull(key.get());
    }

    default public <E> E getOrElse(Key<? extends Value<E>> key, E defaultValue) {
        return this.get(key).orElse(Objects.requireNonNull(defaultValue, "defaultValue"));
    }

    default public <E> E getOrElse(Supplier<? extends Key<? extends Value<E>>> key, E defaultValue) {
        return this.getOrElse(key.get(), defaultValue);
    }

    public <E, V extends Value<E>> Optional<V> getValue(Key<V> var1);

    default public <E, V extends Value<E>> Optional<V> getValue(Supplier<? extends Key<V>> key) {
        return this.getValue(key.get());
    }

    default public <E, V extends Value<E>> V requireValue(Supplier<? extends Key<V>> key) {
        return this.requireValue(key.get());
    }

    default public <E, V extends Value<E>> V requireValue(Key<V> key) {
        return (V)((Value)this.getValue(key).orElseThrow(() -> new NoSuchElementException(String.format("Could not retrieve value for key '%s'", key.toString()))));
    }

    public boolean supports(Key<?> var1);

    default public boolean supports(Supplier<? extends Key<?>> key) {
        return this.supports(key.get());
    }

    default public boolean supports(Value<?> value) {
        return this.supports(value.getKey());
    }

    public Set<Key<?>> getKeys();

    public Set<Value.Immutable<?>> getValues();
}

