/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event.world;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.entity.AffectEntityEvent;
import org.spongepowered.api.world.ServerLocation;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.api.world.server.ServerWorld;

public interface ExplosionEvent
extends Event,
Cancellable {
    public Explosion getExplosion();

    public static interface Post
    extends ExplosionEvent,
    ChangeBlockEvent.Post {
    }

    public static interface Detonate
    extends ExplosionEvent,
    AffectEntityEvent {
        public ServerWorld getWorld();

        public List<ServerLocation> getAffectedLocations();

        default public List<ServerLocation> filterAffectedLocations(Predicate<ServerLocation> predicate) {
            ArrayList<ServerLocation> removedLocations = new ArrayList<ServerLocation>();
            Iterator<ServerLocation> iter = this.getAffectedLocations().iterator();
            while (iter.hasNext()) {
                ServerLocation location = iter.next();
                if (predicate.test(location)) continue;
                iter.remove();
                removedLocations.add(location);
            }
            return removedLocations;
        }
    }

    public static interface Pre
    extends ExplosionEvent {
        public ServerWorld getWorld();

        public void setExplosion(Explosion var1);
    }
}

