/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.merchant;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import org.spongepowered.api.data.type.ProfessionType;
import org.spongepowered.api.item.merchant.Merchant;
import org.spongepowered.api.item.merchant.TradeOffer;
import org.spongepowered.api.item.merchant.TradeOfferListMutator;

public interface VillagerRegistry {
    public Multimap<Integer, TradeOfferListMutator> getTradeOfferLevelMap(ProfessionType var1);

    default public Collection<TradeOfferListMutator> getMutatorsForProfession(ProfessionType profession, int level) {
        Multimap<Integer, TradeOfferListMutator> map = this.getTradeOfferLevelMap(Objects.requireNonNull(profession, "Profession cannot be null!"));
        Collection mutators = map.get((Object)level);
        return ImmutableList.copyOf((Collection)mutators);
    }

    public VillagerRegistry addMutator(ProfessionType var1, int var2, TradeOfferListMutator var3);

    public VillagerRegistry addMutators(ProfessionType var1, int var2, TradeOfferListMutator var3, TradeOfferListMutator ... var4);

    public VillagerRegistry setMutators(ProfessionType var1, int var2, List<TradeOfferListMutator> var3);

    public VillagerRegistry setMutators(ProfessionType var1, Multimap<Integer, TradeOfferListMutator> var2);

    default public Collection<TradeOffer> generateTradeOffers(Merchant merchant, ProfessionType profession, int level, Random random) {
        Objects.requireNonNull(random, "Random cannot be null!");
        ArrayList<TradeOffer> generatedList = new ArrayList<TradeOffer>();
        this.getMutatorsForProfession(profession, level).forEach(mutator -> mutator.accept(merchant, generatedList, random));
        return generatedList;
    }

    default public List<TradeOffer> populateOffers(Merchant merchant, List<TradeOffer> currentOffers, ProfessionType profession, int level, Random random) {
        this.getMutatorsForProfession(profession, level).forEach(mutator -> mutator.accept(merchant, currentOffers, random));
        return currentOffers;
    }
}

