/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.service.ban;

import java.net.InetAddress;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.service.ban.BanType;
import org.spongepowered.api.service.ban.BanTypes;
import org.spongepowered.api.util.CopyableBuilder;

public interface Ban {
    public static Builder builder() {
        return Sponge.getRegistry().getBuilderRegistry().provideBuilder(Builder.class);
    }

    public static Ban of(GameProfile profile) {
        return Ban.builder().type(BanTypes.PROFILE).profile(profile).build();
    }

    public static Ban of(GameProfile profile, Component reason) {
        return Ban.builder().type(BanTypes.PROFILE).profile(profile).reason(reason).build();
    }

    public BanType getType();

    public Optional<Component> getReason();

    public Instant getCreationDate();

    public Optional<Component> getBanSource();

    public Optional<Instant> getExpirationDate();

    default public boolean isIndefinite() {
        return !this.getExpirationDate().isPresent();
    }

    public static interface Builder
    extends CopyableBuilder<Ban, Builder> {
        public Builder profile(GameProfile var1);

        public Builder address(InetAddress var1);

        public Builder type(BanType var1);

        default public Builder type(Supplier<? extends BanType> type) {
            return this.type(Objects.requireNonNull(type.get()));
        }

        public Builder reason(@Nullable Component var1);

        public Builder startDate(Instant var1);

        public Builder expirationDate(@Nullable Instant var1);

        public Builder source(@Nullable Component var1);

        public Ban build();
    }

    public static interface Ip
    extends Ban {
        public InetAddress getAddress();
    }

    public static interface Profile
    extends Ban {
        public GameProfile getProfile();
    }
}

