/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.util.CopyableBuilder;
import org.spongepowered.api.world.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.math.vector.Vector3d;

public final class RespawnLocation
implements DataSerializable {
    private final ResourceKey world;
    private final Vector3d position;
    private final boolean forced;

    public static Builder builder() {
        return new Builder();
    }

    RespawnLocation(Builder builder) {
        this.world = Objects.requireNonNull(builder.world);
        this.position = Objects.requireNonNull(builder.position);
        this.forced = builder.forced;
    }

    public ResourceKey getWorldKey() {
        return this.world;
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public boolean isForced() {
        return this.forced;
    }

    public Optional<ServerLocation> asLocation() {
        Optional<ServerWorld> optWorld = Sponge.getServer().getWorldManager().getWorld(this.getWorldKey());
        return optWorld.map(world -> ServerLocation.of(world, this.getPosition()));
    }

    @Override
    public int getContentVersion() {
        return 2;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew().set(Queries.CONTENT_VERSION, this.getContentVersion()).set(Queries.POSITION_X, this.getPosition().getX()).set(Queries.POSITION_Y, this.getPosition().getY()).set(Queries.POSITION_Z, this.getPosition().getZ()).set(Queries.FORCED_SPAWN, this.isForced()).set(Queries.WORLD_KEY, this.getWorldKey().getFormatted());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RespawnLocation that = (RespawnLocation)o;
        return this.forced == that.forced && Objects.equals(this.world, that.world) && Objects.equals(this.position, that.position);
    }

    public int hashCode() {
        return Objects.hash(this.world, this.position, this.forced);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("world", (Object)this.world).add("position", (Object)this.position).add("forced", this.forced).toString();
    }

    public static final class Builder
    extends AbstractDataBuilder<RespawnLocation>
    implements CopyableBuilder<RespawnLocation, Builder> {
        @Nullable ResourceKey world;
        @Nullable Vector3d position;
        boolean forced = false;

        public Builder() {
            super(RespawnLocation.class, 1);
        }

        public Builder world(ServerWorld world) {
            return this.world(Objects.requireNonNull(world).getKey());
        }

        public Builder world(ResourceKey key) {
            this.world = Objects.requireNonNull(key);
            return this;
        }

        public Builder location(ServerLocation location) {
            Objects.requireNonNull(location);
            ServerWorld world = (ServerWorld)location.getWorld();
            this.position(location.getPosition());
            this.world(world);
            return this;
        }

        public Builder position(Vector3d position) {
            this.position = Objects.requireNonNull(position);
            return this;
        }

        public Builder forceSpawn(boolean isForced) {
            this.forced = isForced;
            return this;
        }

        @Override
        protected Optional<RespawnLocation> buildContent(DataView container) throws InvalidDataException {
            ResourceKey worldKey = container.getKey(Queries.WORLD_KEY).get();
            double x = container.getDouble(Queries.POSITION_X).get();
            double y = container.getDouble(Queries.POSITION_Y).get();
            double z = container.getDouble(Queries.POSITION_Z).get();
            Vector3d position = new Vector3d(x, y, z);
            boolean forcedSpawn = container.getBoolean(Queries.FORCED_SPAWN).orElse(false);
            Builder builder = new Builder().world(worldKey).position(position).forceSpawn(forcedSpawn);
            return Optional.of(new RespawnLocation(builder));
        }

        @Override
        public Builder reset() {
            this.world = null;
            this.position = null;
            this.forced = false;
            return this;
        }

        @Override
        public Builder from(RespawnLocation value) {
            Objects.requireNonNull(value);
            this.world = value.world;
            this.position = value.getPosition();
            this.forced = value.isForced();
            return this;
        }

        public RespawnLocation build() {
            Objects.requireNonNull(this.world);
            Objects.requireNonNull(this.position);
            return new RespawnLocation(this);
        }
    }
}

