/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util.blockray;

import java.util.Optional;
import java.util.function.Predicate;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.util.blockray.RayTraceResult;
import org.spongepowered.api.world.Locatable;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.math.vector.Vector3d;

public interface RayTrace<T extends Locatable> {
    public static RayTrace<LocatableBlock> block() {
        return Sponge.getRegistry().getFactoryRegistry().provideFactory(Factory.class).blockRayTrace();
    }

    public static RayTrace<Entity> entity() {
        return Sponge.getRegistry().getFactoryRegistry().provideFactory(Factory.class).entityRayTrace();
    }

    public static Predicate<LocatableBlock> onlyAir() {
        return Sponge.getRegistry().getFactoryRegistry().provideFactory(Factory.class).onlyAir();
    }

    public static Predicate<LocatableBlock> nonAir() {
        return Sponge.getRegistry().getFactoryRegistry().provideFactory(Factory.class).notAir();
    }

    public RayTrace<T> world(ServerWorld var1);

    default public RayTrace<T> sourcePosition(Entity entity) {
        return this.sourcePosition(entity.getPosition());
    }

    public RayTrace<T> sourceEyePosition(Living var1);

    public RayTrace<T> sourcePosition(Vector3d var1);

    public RayTrace<T> direction(Vector3d var1);

    default public RayTrace<T> direction(Living entity) {
        return this.direction(entity.getHeadDirection());
    }

    public RayTrace<T> limit(int var1);

    public RayTrace<T> continueUntil(Vector3d var1);

    public RayTrace<T> continueWhileLocation(Predicate<ServerLocation> var1);

    public RayTrace<T> continueWhileBlock(Predicate<LocatableBlock> var1);

    public RayTrace<T> continueWhileEntity(Predicate<Entity> var1);

    public RayTrace<T> select(Predicate<T> var1);

    public Optional<RayTraceResult<T>> execute();

    public RayTrace<T> reset();

    public static interface Factory {
        public RayTrace<Entity> entityRayTrace();

        public RayTrace<LocatableBlock> blockRayTrace();

        public Predicate<LocatableBlock> onlyAir();

        public Predicate<LocatableBlock> notAir();
    }
}

