/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world;

import java.util.Optional;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.fluid.FluidState;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.ServerLocation;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public interface Location<W extends World<W>> {
    public W getWorld();

    public Optional<W> getWorldIfAvailable();

    public boolean isAvailable();

    public boolean isValid();

    public Vector3d getPosition();

    public Vector3i getBlockPosition();

    public Vector3i getChunkPosition();

    public Vector3i getBiomePosition();

    public double getX();

    public double getY();

    public double getZ();

    public int getBlockX();

    public int getBlockY();

    public int getBlockZ();

    default public Optional<ServerLocation> onServer() {
        return Optional.ofNullable(this instanceof ServerLocation ? (ServerLocation)this : null);
    }

    public boolean inWorld(W var1);

    public Location<W> withWorld(W var1);

    public Location<W> withPosition(Vector3d var1);

    public Location<W> withBlockPosition(Vector3i var1);

    public Location<W> sub(Vector3d var1);

    public Location<W> sub(Vector3i var1);

    public Location<W> sub(double var1, double var3, double var5);

    public Location<W> add(Vector3d var1);

    public Location<W> add(Vector3i var1);

    public Location<W> add(double var1, double var3, double var5);

    public Location<W> relativeTo(Direction var1);

    public Location<W> relativeToBlock(Direction var1);

    public BiomeType getBiome();

    public boolean hasBlock();

    public BlockState getBlock();

    default public BlockType getBlockType() {
        return this.getBlock().getType();
    }

    public FluidState getFluid();

    public boolean hasBlockEntity();

    public Optional<? extends BlockEntity> getBlockEntity();

    public boolean setBlock(BlockState var1);

    public boolean setBlock(BlockState var1, BlockChangeFlag var2);

    public boolean setBlockType(BlockType var1);

    public boolean setBlockType(BlockType var1, BlockChangeFlag var2);
}

