/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.gen;

import org.spongepowered.api.Sponge;
import org.spongepowered.api.world.ProtoWorld;
import org.spongepowered.api.world.gen.PrimitiveChunk;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.math.vector.Vector3i;

public interface GenerationRegion
extends ProtoWorld<GenerationRegion> {
    public Vector3i getCenterChunkPos();

    default public int getCenterChunkX() {
        return this.getCenterChunkPos().getX();
    }

    default public int getCenterChunkY() {
        return this.getCenterChunkPos().getY();
    }

    default public int getCenterChunkZ() {
        return this.getCenterChunkPos().getZ();
    }

    default public PrimitiveChunk getChunkAtBlock(Vector3i position) {
        return this.getChunkAtBlock(position.getX(), position.getY(), position.getZ());
    }

    default public PrimitiveChunk getChunkAtBlock(int x, int y, int z) {
        return this.getChunk(Sponge.getServer().getChunkLayout().toChunk(x, y, z).orElseThrow(() -> new IllegalArgumentException(String.format("Cannot convert (%s, %s, %s) to chunk coordinates.", x, y, z))));
    }

    default public PrimitiveChunk getChunk(Vector3i chunkPosition) {
        return this.getChunk(chunkPosition.getX(), chunkPosition.getY(), chunkPosition.getZ());
    }

    public PrimitiveChunk getChunk(int var1, int var2, int var3);

    public ServerWorld getWorld();
}

