/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.volume.game;

import java.util.Objects;
import java.util.function.Supplier;
import org.spongepowered.api.world.LightType;
import org.spongepowered.api.world.LightTypes;
import org.spongepowered.api.world.volume.biome.ReadableBiomeVolume;
import org.spongepowered.api.world.volume.game.PrimitiveGameVolume;
import org.spongepowered.math.vector.Vector3i;

public interface EnvironmentalVolume
extends PrimitiveGameVolume,
ReadableBiomeVolume {
    public int getLight(LightType var1, int var2, int var3, int var4);

    default public int getLight(Supplier<? extends LightType> type, int x, int y, int z) {
        Objects.requireNonNull(type);
        return this.getLight(type.get(), x, y, z);
    }

    default public int getLight(LightType type, Vector3i position) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(position);
        return this.getLight(type, position.getX(), position.getY(), position.getZ());
    }

    default public int getLight(Supplier<? extends LightType> type, Vector3i position) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(position);
        return this.getLight(type, position.getX(), position.getY(), position.getZ());
    }

    default public int getLight(int x, int y, int z) {
        return this.getLight(LightTypes.BLOCK, x, y, z);
    }

    default public int getLight(Vector3i position) {
        Objects.requireNonNull(position);
        return this.getLight(position.getX(), position.getY(), position.getZ());
    }

    default public boolean isSkylightMax(Vector3i position) {
        Objects.requireNonNull(position);
        return this.getLight(LightTypes.SKY, position) >= this.getMaximumLight();
    }
}

