/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.volume.stream;

import java.util.Objects;
import java.util.Optional;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.block.entity.BlockEntityArchetype;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.LocationCreator;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.volume.biome.MutableBiomeVolume;
import org.spongepowered.api.world.volume.block.MutableBlockVolume;
import org.spongepowered.api.world.volume.block.PhysicsAwareMutableBlockVolume;
import org.spongepowered.api.world.volume.block.entity.MutableBlockEntityVolume;
import org.spongepowered.api.world.volume.entity.MutableEntityVolume;
import org.spongepowered.api.world.volume.stream.VolumeApplicator;

public final class VolumeApplicators {
    public static <M extends MutableBlockVolume<M>> VolumeApplicator<M, BlockState, Boolean> applyBlocks() {
        return (volume, element) -> volume.setBlock(element.getPosition(), (BlockState)element.getType());
    }

    public static <M extends PhysicsAwareMutableBlockVolume<M>> VolumeApplicator<M, BlockState, Boolean> applyBlocks(BlockChangeFlag flag) {
        Objects.requireNonNull(flag, "BlockChangeFlag cannot be null!");
        return (volume, element) -> volume.setBlock(element.getPosition(), (BlockState)element.getType(), flag);
    }

    public static <M extends MutableBlockEntityVolume<M>> VolumeApplicator<M, BlockEntity, Boolean> applyBlockEntities() {
        return (volume, element) -> {
            if (volume.setBlock(element.getPosition(), ((BlockEntity)element.getType()).getBlock())) {
                volume.addBlockEntity(element.getPosition(), (BlockEntity)element.getType());
                return true;
            }
            return false;
        };
    }

    public static <M extends MutableBlockEntityVolume<M>> VolumeApplicator<M, Optional<? extends BlockEntity>, Boolean> applyOrRemoveBlockEntities() {
        return (volume, element) -> {
            Optional blockEntityOpt = (Optional)element.getType();
            if (blockEntityOpt.isPresent()) {
                BlockEntity blockEntity = (BlockEntity)blockEntityOpt.get();
                if (volume.setBlock(element.getPosition(), blockEntity.getBlock())) {
                    volume.addBlockEntity(element.getPosition(), blockEntity);
                    return true;
                }
                return false;
            }
            return volume.removeBlock(element.getPosition());
        };
    }

    public static <M extends MutableBlockVolume<M>> VolumeApplicator<M, Optional<BlockState>, Boolean> applyOrRemoveBlockState() {
        return (volume, element) -> ((Optional)element.getType()).map(blockState -> volume.setBlock(element.getPosition(), (BlockState)blockState)).orElseGet(() -> volume.removeBlock(element.getPosition()));
    }

    public static <M extends PhysicsAwareMutableBlockVolume<M>> VolumeApplicator<M, Optional<BlockState>, Boolean> applyOrRemoveBlockState(BlockChangeFlag flag) {
        return (volume, element) -> ((Optional)element.getType()).map(blockState -> volume.setBlock(element.getPosition(), (BlockState)blockState, flag)).orElseGet(() -> volume.removeBlock(element.getPosition()));
    }

    public static <M extends LocationCreator & MutableBlockEntityVolume<M>> VolumeApplicator<M, BlockEntityArchetype, Optional<? extends BlockEntity>> applyBlockEntityArchetype() {
        return (volume, element) -> ((BlockEntityArchetype)element.getType()).apply(volume.getLocation(element.getPosition()));
    }

    public static <M extends MutableEntityVolume<M>> VolumeApplicator<M, Entity, Boolean> applyEntities() {
        return (volume, element) -> volume.spawnEntity((Entity)element.getType());
    }

    public static <M extends MutableBiomeVolume<M>> VolumeApplicator<M, BiomeType, Boolean> applyBiomes() {
        return (volume, element) -> volume.setBiome(element.getPosition(), (BiomeType)element.getType());
    }

    public static <M extends LocationCreator & MutableEntityVolume<M>> VolumeApplicator<M, EntityArchetype, Optional<? extends Entity>> applyEntityArchetype() {
        return (volume, element) -> ((EntityArchetype)element.getType()).apply(volume.getLocation(element.getPosition()));
    }

    private VolumeApplicators() {
    }
}

