/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.adventure;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.IOException;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.serializer.gson.LegacyHoverEventSerializer;
import net.kyori.adventure.text.serializer.plain.PlainComponentSerializer;
import net.kyori.adventure.util.Codec;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class NbtLegacyHoverEventSerializer
implements LegacyHoverEventSerializer {
    public static final NbtLegacyHoverEventSerializer INSTANCE = new NbtLegacyHoverEventSerializer();
    private static final Codec<CompoundNBT, String, CommandSyntaxException, RuntimeException> SNBT_CODEC = Codec.of(JsonToNBT::getTagFromJson, INBT::toString);
    static final String ITEM_TYPE = "id";
    static final String ITEM_COUNT = "Count";
    static final String ITEM_TAG = "tag";
    static final String ENTITY_NAME = "name";
    static final String ENTITY_TYPE = "type";
    static final String ENTITY_ID = "id";

    private NbtLegacyHoverEventSerializer() {
    }

    public HoverEvent.ShowItem deserializeShowItem(Component input) throws IOException {
        String rawContent = PlainComponentSerializer.plain().serialize(input);
        try {
            CompoundNBT contents = (CompoundNBT)SNBT_CODEC.decode((Object)rawContent);
            CompoundNBT tag = contents.getCompound(ITEM_TAG);
            return HoverEvent.ShowItem.of((Key)Key.key((String)contents.getString("id")), (int)(contents.contains(ITEM_COUNT) ? contents.getByte(ITEM_COUNT) : (byte)1), tag.isEmpty() ? null : BinaryTagHolder.encode((Object)tag, SNBT_CODEC));
        }
        catch (CommandSyntaxException ex) {
            throw new IOException(ex);
        }
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull HoverEvent.ShowEntity deserializeShowEntity(Component input, Codec.Decoder<Component, String, ? extends RuntimeException> componentCodec) throws IOException {
        String raw = PlainComponentSerializer.plain().serialize(input);
        try {
            CompoundNBT contents = (CompoundNBT)SNBT_CODEC.decode((Object)raw);
            return HoverEvent.ShowEntity.of((Key)Key.key((String)contents.getString(ENTITY_TYPE)), (UUID)UUID.fromString(contents.getString("id")), (Component)((Component)componentCodec.decode((Object)contents.getString(ENTITY_NAME))));
        }
        catch (CommandSyntaxException ex) {
            throw new IOException(ex);
        }
    }

    public @NonNull Component serializeShowItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull HoverEvent.ShowItem input) throws IOException {
        CompoundNBT tag = new CompoundNBT();
        tag.putString("id", input.item().asString());
        tag.putByte(ITEM_COUNT, (byte)input.count());
        if (input.nbt() != null) {
            try {
                tag.put(ITEM_TAG, (INBT)input.nbt().get(SNBT_CODEC));
            }
            catch (CommandSyntaxException ex) {
                throw new IOException(ex);
            }
        }
        return Component.text((String)((String)SNBT_CODEC.encode((Object)tag)));
    }

    public @NonNull Component serializeShowEntity(HoverEvent.ShowEntity input, Codec.Encoder<Component, String, ? extends RuntimeException> componentCodec) {
        CompoundNBT tag = new CompoundNBT();
        tag.putString("id", input.id().toString());
        tag.putString(ENTITY_TYPE, input.type().asString());
        if (input.name() != null) {
            tag.putString(ENTITY_NAME, (String)componentCodec.encode((Object)input.name()));
        }
        return Component.text((String)((String)SNBT_CODEC.encode((Object)tag)));
    }
}

