/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.adventure;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.netty.util.AttributeKey;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.serializer.configurate4.ConfigurateComponentSerializer;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.gson.LegacyHoverEventSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainComponentSerializer;
import net.kyori.adventure.util.Codec;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.server.ServerBossInfo;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.adventure.SpongeComponents;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.common.adventure.NbtLegacyHoverEventSerializer;
import org.spongepowered.common.adventure.SpongeCallback;
import org.spongepowered.common.bridge.adventure.BossBarBridge;
import org.spongepowered.common.bridge.adventure.ComponentBridge;
import org.spongepowered.common.bridge.adventure.StyleBridge;
import org.spongepowered.common.bridge.util.text.TextComponentBridge;
import org.spongepowered.common.bridge.world.BossInfoBridge;

public final class SpongeAdventure {
    public static final AttributeKey<Locale> CHANNEL_LOCALE = AttributeKey.newInstance((String)"sponge:locale");
    public static final SpongeCallback CALLBACK_COMMAND = new SpongeCallback();
    public static final GsonComponentSerializer GSON = GsonComponentSerializer.builder().legacyHoverEventSerializer((LegacyHoverEventSerializer)NbtLegacyHoverEventSerializer.INSTANCE).downsampleColors().emitLegacyHoverEvent().build();
    public static final Codec<CompoundNBT, String, IOException, IOException> NBT_CODEC = new Codec<CompoundNBT, String, IOException, IOException>(){

        public @NonNull CompoundNBT decode(@NonNull String encoded) throws IOException {
            try {
                return JsonToNBT.getTagFromJson((String)encoded);
            }
            catch (CommandSyntaxException e) {
                throw new IOException(e);
            }
        }

        public @NonNull String encode(@NonNull CompoundNBT decoded) {
            return decoded.toString();
        }
    };
    public static final ConfigurateComponentSerializer CONFIGURATE = ConfigurateComponentSerializer.builder().scalarSerializer((ComponentSerializer)GSON).build();
    private static final Set<ServerBossInfo> ACTIVE_BOSS_BARS = ConcurrentHashMap.newKeySet();

    public static Component legacy(char character, String string) {
        return LegacyComponentSerializer.legacy((char)character).deserialize(string);
    }

    public static String legacy(char character, Component component) {
        return LegacyComponentSerializer.legacy((char)character).serialize(component);
    }

    public static String legacySection(Component component) {
        return LegacyComponentSerializer.legacySection().serialize(component);
    }

    public static Component legacySection(String string) {
        return LegacyComponentSerializer.legacySection().deserialize(string);
    }

    public static String legacyAmpersand(Component component) {
        return LegacyComponentSerializer.legacyAmpersand().serialize(component);
    }

    public static Component legacyAmpersand(String string) {
        return LegacyComponentSerializer.legacyAmpersand().deserialize(string);
    }

    public static Component json(String string) {
        return GSON.deserialize((Object)string);
    }

    public static String json(Component string) {
        return (String)GSON.serialize(string);
    }

    public static String plain(Component component) {
        return PlainComponentSerializer.plain().serialize(component);
    }

    public static ITextComponent asVanilla(Component component) {
        return ((ComponentBridge)component).bridge$asVanillaComponent();
    }

    public static Component asAdventure(ITextComponent component) {
        return ((TextComponentBridge)component).bridge$asAdventureComponent();
    }

    public static Style asVanilla(net.kyori.adventure.text.format.Style style) {
        return ((StyleBridge)style).bridge$asVanilla();
    }

    public static TextFormatting asVanilla(NamedTextColor color) {
        if (color == NamedTextColor.BLACK) {
            return TextFormatting.BLACK;
        }
        if (color == NamedTextColor.DARK_BLUE) {
            return TextFormatting.DARK_BLUE;
        }
        if (color == NamedTextColor.DARK_GREEN) {
            return TextFormatting.DARK_GREEN;
        }
        if (color == NamedTextColor.DARK_AQUA) {
            return TextFormatting.DARK_AQUA;
        }
        if (color == NamedTextColor.DARK_RED) {
            return TextFormatting.DARK_RED;
        }
        if (color == NamedTextColor.DARK_PURPLE) {
            return TextFormatting.DARK_PURPLE;
        }
        if (color == NamedTextColor.GOLD) {
            return TextFormatting.GOLD;
        }
        if (color == NamedTextColor.GRAY) {
            return TextFormatting.GRAY;
        }
        if (color == NamedTextColor.DARK_GRAY) {
            return TextFormatting.DARK_GRAY;
        }
        if (color == NamedTextColor.BLUE) {
            return TextFormatting.BLUE;
        }
        if (color == NamedTextColor.GREEN) {
            return TextFormatting.GREEN;
        }
        if (color == NamedTextColor.AQUA) {
            return TextFormatting.AQUA;
        }
        if (color == NamedTextColor.RED) {
            return TextFormatting.RED;
        }
        if (color == NamedTextColor.LIGHT_PURPLE) {
            return TextFormatting.LIGHT_PURPLE;
        }
        if (color == NamedTextColor.YELLOW) {
            return TextFormatting.YELLOW;
        }
        if (color == NamedTextColor.WHITE) {
            return TextFormatting.WHITE;
        }
        throw new IllegalArgumentException();
    }

    public static @Nullable NamedTextColor asAdventureNamed(@Nullable TextFormatting color) {
        if (color == null) {
            return null;
        }
        if (color == TextFormatting.BLACK) {
            return NamedTextColor.BLACK;
        }
        if (color == TextFormatting.DARK_BLUE) {
            return NamedTextColor.DARK_BLUE;
        }
        if (color == TextFormatting.DARK_GREEN) {
            return NamedTextColor.DARK_GREEN;
        }
        if (color == TextFormatting.DARK_AQUA) {
            return NamedTextColor.DARK_AQUA;
        }
        if (color == TextFormatting.DARK_RED) {
            return NamedTextColor.DARK_RED;
        }
        if (color == TextFormatting.DARK_PURPLE) {
            return NamedTextColor.DARK_PURPLE;
        }
        if (color == TextFormatting.GOLD) {
            return NamedTextColor.GOLD;
        }
        if (color == TextFormatting.GRAY) {
            return NamedTextColor.GRAY;
        }
        if (color == TextFormatting.DARK_GRAY) {
            return NamedTextColor.DARK_GRAY;
        }
        if (color == TextFormatting.BLUE) {
            return NamedTextColor.BLUE;
        }
        if (color == TextFormatting.GREEN) {
            return NamedTextColor.GREEN;
        }
        if (color == TextFormatting.AQUA) {
            return NamedTextColor.AQUA;
        }
        if (color == TextFormatting.RED) {
            return NamedTextColor.RED;
        }
        if (color == TextFormatting.LIGHT_PURPLE) {
            return NamedTextColor.LIGHT_PURPLE;
        }
        if (color == TextFormatting.YELLOW) {
            return NamedTextColor.YELLOW;
        }
        return NamedTextColor.WHITE;
    }

    public static Boolean asVanilla(TextDecoration.State state) {
        if (state == TextDecoration.State.TRUE) {
            return true;
        }
        if (state == TextDecoration.State.FALSE) {
            return false;
        }
        return null;
    }

    public static ChatType asVanilla(MessageType type) {
        if (type == MessageType.SYSTEM) {
            return ChatType.SYSTEM;
        }
        if (type == MessageType.CHAT) {
            return ChatType.CHAT;
        }
        throw new IllegalArgumentException(type.name());
    }

    public static HoverEvent.Action<?> asAdventure(HoverEvent.Action action) {
        if (action == HoverEvent.Action.SHOW_TEXT) {
            return HoverEvent.Action.SHOW_TEXT;
        }
        if (action == HoverEvent.Action.SHOW_ITEM) {
            return HoverEvent.Action.SHOW_ITEM;
        }
        if (action == HoverEvent.Action.SHOW_ENTITY) {
            return HoverEvent.Action.SHOW_ENTITY;
        }
        throw new IllegalArgumentException(action.toString());
    }

    public static HoverEvent.Action asVanilla(HoverEvent.Action<?> action) {
        if (action == HoverEvent.Action.SHOW_TEXT) {
            return HoverEvent.Action.SHOW_TEXT;
        }
        if (action == HoverEvent.Action.SHOW_ITEM) {
            return HoverEvent.Action.SHOW_ITEM;
        }
        if (action == HoverEvent.Action.SHOW_ENTITY) {
            return HoverEvent.Action.SHOW_ENTITY;
        }
        throw new IllegalArgumentException(action.toString());
    }

    public static ClickEvent.Action asAdventure(ClickEvent.Action action) {
        if (action == ClickEvent.Action.OPEN_URL) {
            return ClickEvent.Action.OPEN_URL;
        }
        if (action == ClickEvent.Action.OPEN_FILE) {
            return ClickEvent.Action.OPEN_FILE;
        }
        if (action == ClickEvent.Action.RUN_COMMAND) {
            return ClickEvent.Action.RUN_COMMAND;
        }
        if (action == ClickEvent.Action.SUGGEST_COMMAND) {
            return ClickEvent.Action.SUGGEST_COMMAND;
        }
        if (action == ClickEvent.Action.CHANGE_PAGE) {
            return ClickEvent.Action.CHANGE_PAGE;
        }
        throw new IllegalArgumentException(action.toString());
    }

    public static ClickEvent.Action asVanilla(ClickEvent.Action action) {
        if (action == ClickEvent.Action.OPEN_URL) {
            return ClickEvent.Action.OPEN_URL;
        }
        if (action == ClickEvent.Action.OPEN_FILE) {
            return ClickEvent.Action.OPEN_FILE;
        }
        if (action == ClickEvent.Action.RUN_COMMAND) {
            return ClickEvent.Action.RUN_COMMAND;
        }
        if (action == ClickEvent.Action.SUGGEST_COMMAND) {
            return ClickEvent.Action.SUGGEST_COMMAND;
        }
        if (action == ClickEvent.Action.CHANGE_PAGE) {
            return ClickEvent.Action.CHANGE_PAGE;
        }
        if (action == ClickEvent.Action.COPY_TO_CLIPBOARD) {
            return ClickEvent.Action.COPY_TO_CLIPBOARD;
        }
        throw new IllegalArgumentException(action.toString());
    }

    public static List<Component> json(List<String> strings) {
        ArrayList<Component> components = new ArrayList<Component>();
        for (String string : strings) {
            components.add(SpongeAdventure.json(string));
        }
        return components;
    }

    public static ListNBT listTagJson(List<Component> components) {
        ListNBT nbt = new ListNBT();
        for (Component component : components) {
            nbt.add((Object)StringNBT.valueOf((String)SpongeAdventure.json(component)));
        }
        return nbt;
    }

    public static BossBar asAdventure(BossInfo bar) {
        return ((BossInfoBridge)bar).bridge$asAdventure();
    }

    public static ServerBossInfo asVanillaServer(BossBar bar) {
        return ((BossBarBridge)bar).bridge$asVanillaServerBar();
    }

    public static BossInfo.Color asVanilla(BossBar.Color color) {
        if (color == BossBar.Color.PINK) {
            return BossInfo.Color.PINK;
        }
        if (color == BossBar.Color.BLUE) {
            return BossInfo.Color.BLUE;
        }
        if (color == BossBar.Color.RED) {
            return BossInfo.Color.RED;
        }
        if (color == BossBar.Color.GREEN) {
            return BossInfo.Color.GREEN;
        }
        if (color == BossBar.Color.YELLOW) {
            return BossInfo.Color.YELLOW;
        }
        if (color == BossBar.Color.PURPLE) {
            return BossInfo.Color.PURPLE;
        }
        if (color == BossBar.Color.WHITE) {
            return BossInfo.Color.WHITE;
        }
        throw new IllegalArgumentException(color.name());
    }

    public static BossBar.Color asAdventure(BossInfo.Color color) {
        if (color == BossInfo.Color.PINK) {
            return BossBar.Color.PINK;
        }
        if (color == BossInfo.Color.BLUE) {
            return BossBar.Color.BLUE;
        }
        if (color == BossInfo.Color.RED) {
            return BossBar.Color.RED;
        }
        if (color == BossInfo.Color.GREEN) {
            return BossBar.Color.GREEN;
        }
        if (color == BossInfo.Color.YELLOW) {
            return BossBar.Color.YELLOW;
        }
        if (color == BossInfo.Color.PURPLE) {
            return BossBar.Color.PURPLE;
        }
        if (color == BossInfo.Color.WHITE) {
            return BossBar.Color.WHITE;
        }
        throw new IllegalArgumentException(color.name());
    }

    public static BossInfo.Overlay asVanilla(BossBar.Overlay overlay) {
        if (overlay == BossBar.Overlay.PROGRESS) {
            return BossInfo.Overlay.PROGRESS;
        }
        if (overlay == BossBar.Overlay.NOTCHED_6) {
            return BossInfo.Overlay.NOTCHED_6;
        }
        if (overlay == BossBar.Overlay.NOTCHED_10) {
            return BossInfo.Overlay.NOTCHED_10;
        }
        if (overlay == BossBar.Overlay.NOTCHED_12) {
            return BossInfo.Overlay.NOTCHED_12;
        }
        if (overlay == BossBar.Overlay.NOTCHED_20) {
            return BossInfo.Overlay.NOTCHED_20;
        }
        throw new IllegalArgumentException(overlay.name());
    }

    public static BossBar.Overlay asAdventure(BossInfo.Overlay overlay) {
        if (overlay == BossInfo.Overlay.PROGRESS) {
            return BossBar.Overlay.PROGRESS;
        }
        if (overlay == BossInfo.Overlay.NOTCHED_6) {
            return BossBar.Overlay.NOTCHED_6;
        }
        if (overlay == BossInfo.Overlay.NOTCHED_10) {
            return BossBar.Overlay.NOTCHED_10;
        }
        if (overlay == BossInfo.Overlay.NOTCHED_12) {
            return BossBar.Overlay.NOTCHED_12;
        }
        if (overlay == BossInfo.Overlay.NOTCHED_20) {
            return BossBar.Overlay.NOTCHED_20;
        }
        throw new IllegalArgumentException(overlay.name());
    }

    public static Set<BossBar.Flag> asAdventureFlags(boolean darkenScreen, boolean playBossMusic, boolean createWorldFog) {
        EnumSet<BossBar.Flag> flags = EnumSet.noneOf(BossBar.Flag.class);
        if (darkenScreen) {
            flags.add(BossBar.Flag.DARKEN_SCREEN);
        }
        if (playBossMusic) {
            flags.add(BossBar.Flag.PLAY_BOSS_MUSIC);
        }
        if (createWorldFog) {
            flags.add(BossBar.Flag.CREATE_WORLD_FOG);
        }
        return flags;
    }

    public static @Nullable BinaryTagHolder asBinaryTagHolder(@Nullable CompoundNBT tag) {
        if (tag == null) {
            return null;
        }
        try {
            return BinaryTagHolder.encode((Object)tag, NBT_CODEC);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static ResourceLocation asVanilla(Key key) {
        if (key instanceof ResourceLocation) {
            return (ResourceLocation)key;
        }
        return new ResourceLocation(key.namespace(), key.value());
    }

    public static @Nullable ResourceLocation asVanillaNullable(@Nullable Key key) {
        if (key == null) {
            return null;
        }
        return SpongeAdventure.asVanilla(key);
    }

    public static Sound.Source asAdventure(SoundCategory source) {
        switch (source) {
            case MASTER: {
                return Sound.Source.MASTER;
            }
            case MUSIC: {
                return Sound.Source.MUSIC;
            }
            case RECORDS: {
                return Sound.Source.RECORD;
            }
            case WEATHER: {
                return Sound.Source.WEATHER;
            }
            case BLOCKS: {
                return Sound.Source.BLOCK;
            }
            case HOSTILE: {
                return Sound.Source.HOSTILE;
            }
            case NEUTRAL: {
                return Sound.Source.NEUTRAL;
            }
            case PLAYERS: {
                return Sound.Source.PLAYER;
            }
            case AMBIENT: {
                return Sound.Source.AMBIENT;
            }
            case VOICE: {
                return Sound.Source.VOICE;
            }
        }
        throw new IllegalArgumentException(source.name());
    }

    public static SoundCategory asVanilla(Sound.Source source) {
        switch (source) {
            case MASTER: {
                return SoundCategory.MASTER;
            }
            case MUSIC: {
                return SoundCategory.MUSIC;
            }
            case RECORD: {
                return SoundCategory.RECORDS;
            }
            case WEATHER: {
                return SoundCategory.WEATHER;
            }
            case BLOCK: {
                return SoundCategory.BLOCKS;
            }
            case HOSTILE: {
                return SoundCategory.HOSTILE;
            }
            case NEUTRAL: {
                return SoundCategory.NEUTRAL;
            }
            case PLAYER: {
                return SoundCategory.PLAYERS;
            }
            case AMBIENT: {
                return SoundCategory.AMBIENT;
            }
            case VOICE: {
                return SoundCategory.VOICE;
            }
        }
        throw new IllegalArgumentException(source.name());
    }

    public static @Nullable SoundCategory asVanillaNullable(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Sound.Source source) {
        if (source == null) {
            return null;
        }
        return SpongeAdventure.asVanilla(source);
    }

    public static void registerBossBar(ServerBossInfo mcBar) {
        ACTIVE_BOSS_BARS.add(mcBar);
    }

    public static void unregisterBossBar(ServerBossInfo mcBar) {
        ACTIVE_BOSS_BARS.remove(mcBar);
    }

    public static void forEachBossBar(Consumer<ServerBossInfo> info) {
        ACTIVE_BOSS_BARS.forEach(info);
    }

    public static class Factory
    implements SpongeComponents.Factory {
        @Override
        public @NonNull ClickEvent callbackClickEvent(@NonNull Consumer<CommandCause> callback) {
            Objects.requireNonNull(callback);
            UUID key = CALLBACK_COMMAND.registerCallback(callback);
            return ClickEvent.runCommand((String)("/sponge:callback " + key.toString()));
        }
    }
}

